/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.mail.MailQueueManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import javax.inject.Inject;

@WebSudoRequired
public class MailQueueAdmin
extends JiraWebActionSupport {
    boolean flush = false;
    boolean resend = false;
    boolean delete = false;
    boolean unstick = false;
    private String page = "";
    private final NotificationSchemeManager notificationSchemeManager;
    private final MailQueueManager queueManager;

    @Inject
    public MailQueueAdmin(MailQueueManager queueManager, NotificationSchemeManager notificationSchemeManager) {
        this.queueManager = queueManager;
        this.notificationSchemeManager = notificationSchemeManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        if (this.flush) {
            this.queueManager.flush();
        } else if (this.resend) {
            this.queueManager.resendError();
        } else if (this.delete) {
            this.queueManager.emptyError();
        } else if (this.unstick) {
            this.queueManager.unstick();
        }
        return this.getRedirect("MailQueueAdmin!default.jspa?page=" + this.getPage());
    }

    public MailQueue getMailQueue() {
        return this.queueManager.getMailQueue();
    }

    public Collection<MailQueueItem> getQueuedItems() {
        Queue queue = "errorqueue".equals(this.page) ? this.getMailQueue().getErrorQueue() : this.getMailQueue().getQueue();
        ArrayList<MailQueueItem> queueList = new ArrayList<MailQueueItem>();
        queueList.addAll(queue);
        return queueList;
    }

    public void setFlush(boolean flush) {
        this.flush = flush;
    }

    public void setResend(boolean resend) {
        this.resend = resend;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setUnstick(boolean unstick) {
        this.unstick = unstick;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public boolean isSending() {
        return this.getMailQueue().isSending();
    }

    public String getPrettySendingStartTime() {
        if (this.isSending()) {
            return ((DateTimeFormatterFactory)ComponentAccessor.getComponent(DateTimeFormatterFactory.class)).formatter().withLocale(this.getLocale()).withStyle(DateTimeStyle.COMPLETE).format((Date)this.getMailQueue().getSendingStarted());
        }
        return "";
    }

    public String getTimeSpentSendingCurrentItem() {
        if (this.isSending()) {
            Timestamp started = this.getMailQueue().getSendingStarted();
            long timeTaken = System.currentTimeMillis() - started.getTime();
            return DateUtils.getDurationString((long)(timeTaken / 1000L));
        }
        return "";
    }

    public boolean isMailSendingDisabled() {
        return MailFactory.isSendingDisabled();
    }

    public boolean isHasMailServer() {
        try {
            SMTPMailServer smtp = MailFactory.getServerManager().getDefaultSMTPMailServer();
            if (smtp != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isEnabledNotificationSchemes() {
        List projects = this.getProjectManager().getProjectObjects();
        for (Project project : projects) {
            Scheme projectScheme = this.notificationSchemeManager.getSchemeFor(project);
            if (projectScheme == null) continue;
            return true;
        }
        return false;
    }
}

