/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.util.FileSize;
import com.atlassian.jira.config.util.AttachmentConfigStore;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.filestore.AttachmentFileStoreProvider;
import com.atlassian.jira.filestore.FileStoreInformation;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.Objects;

@WebSudoRequired
public class ViewAttachmentSettings
extends ProjectActionSupport {
    protected final transient AttachmentConfigStore attachmentConfigStore;
    protected final transient AttachmentPathManager attachmentPathManager;
    protected final transient AttachmentFileStoreProvider attachmentFileStoreProvider;
    protected final transient PageBuilderService pageBuilderService;

    public ViewAttachmentSettings(ProjectManager projectManager, PermissionManager permissionManager, AttachmentFileStoreProvider attachmentFileStoreProvider, AttachmentPathManager attachmentPathManager, AttachmentConfigStore attachmentConfigStore, PageBuilderService pageBuilderService) {
        super(projectManager, permissionManager);
        this.attachmentFileStoreProvider = Objects.requireNonNull(attachmentFileStoreProvider);
        this.attachmentPathManager = Objects.requireNonNull(attachmentPathManager);
        this.attachmentConfigStore = Objects.requireNonNull(attachmentConfigStore);
        this.pageBuilderService = Objects.requireNonNull(pageBuilderService);
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:filestore-information-resources");
        return super.doExecute();
    }

    protected boolean isAttachmentModeCustom() {
        return this.attachmentPathManager.getMode() == AttachmentPathManager.Mode.CUSTOM;
    }

    public FileStoreInformation.Internationalized getAttachmentsLocation() {
        return this.attachmentFileStoreProvider.getInformation().getInternationalizedView((I18nHelper)this);
    }

    public String getPrettyAttachmentSize() {
        return FileSize.format((long)this.attachmentConfigStore.getConfig().getMaxAttachmentSize());
    }

    public boolean getZipSupport() {
        return this.attachmentConfigStore.getConfig().isZipSupportEnabled();
    }

    public String getExtensionRestrictionMode() {
        return this.attachmentConfigStore.getConfig().getExtensionRestrictionMode().getKey();
    }

    public String getFilteredFileExtensions() {
        return this.attachmentConfigStore.getConfig().getFilteredFileExtensions();
    }

    public boolean isFilterFilesWithoutExtensions() {
        return this.attachmentConfigStore.getConfig().isFilterFilesWithoutExtensions();
    }
}

