/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.avatar.AvatarFileStoreProvider;
import com.atlassian.jira.avatar.GravatarSettings;
import com.atlassian.jira.filestore.FileStoreInformation;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.type.ProjectTypeKeys;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Objects;

@WebSudoRequired
public class ViewAvatarSettings
extends ProjectActionSupport {
    private static final String JIRA_AVATAR_PAGE_DESCRIPTION = "admin.avatarsettings.avatar.jira.explanation";
    private static final String JSM_AVATAR_PAGE_DESCRIPTION = "admin.avatarsettings.avatar.jsm.explanation";
    private final transient AvatarFileStoreProvider fileStoreProvider;
    private final transient GravatarSettings gravatarSettings;
    private final transient ProjectTypeManager projectTypeManager;

    public ViewAvatarSettings(AvatarFileStoreProvider fileStoreProvider, ProjectManager projectManager, PermissionManager permissionManager, ProjectTypeManager projectTypeManager, GravatarSettings gravatarSettings) {
        super(projectManager, permissionManager);
        this.fileStoreProvider = Objects.requireNonNull(fileStoreProvider);
        this.projectTypeManager = Objects.requireNonNull(projectTypeManager);
        this.gravatarSettings = Objects.requireNonNull(gravatarSettings);
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    public FileStoreInformation.Internationalized getAvatarsLocation() {
        return this.fileStoreProvider.getInformation().getInternationalizedView((I18nHelper)this);
    }

    public String getAvatarSettingsPageDescription() {
        if (this.projectTypeManager.getAccessibleProjectType(ProjectTypeKeys.SERVICE_DESK).isEmpty()) {
            return String.format(this.getText(JIRA_AVATAR_PAGE_DESCRIPTION), new Object[0]);
        }
        return String.format(this.getText(JSM_AVATAR_PAGE_DESCRIPTION), new Object[0]);
    }

    public Boolean isUseGravatar() {
        return this.gravatarSettings.isAllowGravatars();
    }

    public String getGravatarApiAddress() {
        return this.gravatarSettings.getCustomApiAddress();
    }
}

