/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.currentusers;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.util.lists.ListPager;
import com.atlassian.jira.web.session.currentusers.JiraUserSession;
import com.atlassian.jira.web.session.currentusers.JiraUserSessionTracker;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@WebSudoRequired
public class CurrentUsersList
extends JiraWebActionSupport {
    private static final String DATE_FORMAT = "hh:mm:ss a yyyy/MM/dd z (Z)";
    private final JiraUserSessionTracker jiraUserSessionTracker;
    private final UserManager userManager;
    private ListPager<JiraUserSessionDisplayBean> pager;
    private int pageNo = 0;
    private int rowsPerPage = 50;

    public CurrentUsersList(JiraUserSessionTracker jiraUserSessionTracker, UserManager userManager) {
        this.jiraUserSessionTracker = jiraUserSessionTracker;
        this.userManager = userManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        this.pager = this.convertToDisplayBeansPager(this.jiraUserSessionTracker.getSnapshot());
        return "input";
    }

    private ListPager<JiraUserSessionDisplayBean> convertToDisplayBeansPager(List<JiraUserSession> sessions) {
        ArrayList<JiraUserSessionDisplayBean> displayBeans = new ArrayList<JiraUserSessionDisplayBean>(sessions.size());
        for (JiraUserSession userSession : sessions) {
            displayBeans.add(new JiraUserSessionDisplayBean(userSession));
        }
        return new ListPager<JiraUserSessionDisplayBean>(displayBeans, this.pageNo, this.rowsPerPage){

            @Override
            protected String generatePageURL(int targetPageNo, int rowsPerPage) {
                return "CurrentUsersList.jspa" + "?pageNo=" + targetPageNo;
            }
        };
    }

    public ListPager<JiraUserSessionDisplayBean> getPager() {
        return this.pager;
    }

    public int getFromIndex() {
        return this.pager.getFromIndex() + 1;
    }

    public int getToIndex() {
        return this.pager.getToIndex();
    }

    public String getServerTime() {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date());
    }

    private String nvl(String s) {
        return s == null ? this.notAvailable() : s;
    }

    private String toDateStr(Date date) {
        String dateStr = null;
        if (date != null) {
            long millisAgo = System.currentTimeMillis() - date.getTime();
            long secondsAgo = millisAgo / 1000L;
            String timeAgoStr = DateUtils.getDurationString((long)secondsAgo);
            if (secondsAgo < 60L) {
                timeAgoStr = secondsAgo + "s";
            }
            dateStr = new SimpleDateFormat(DATE_FORMAT).format(date) + " " + this.getText("admin.currentusers.seconds.ago", timeAgoStr);
        }
        return this.nvl(dateStr);
    }

    private String notAvailable() {
        return this.getText("admin.currentusers.not.available");
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    private class JiraUserSessionDisplayBean {
        private final JiraUserSession jiraUserSession;

        private JiraUserSessionDisplayBean(JiraUserSession jiraUserSession) {
            this.jiraUserSession = jiraUserSession;
        }

        public String getId() {
            return CurrentUsersList.this.nvl(this.jiraUserSession.getId());
        }

        public String getASessionId() {
            return CurrentUsersList.this.nvl(this.jiraUserSession.getASessionId());
        }

        public boolean isValidUser() {
            return this.isValidUserImpl(this.jiraUserSession.getUserName());
        }

        public String getUserName() {
            return CurrentUsersList.this.nvl(this.getSmartUserName());
        }

        private String getSmartUserName() {
            String userName = this.jiraUserSession.getUserName();
            if (!this.isValidUserImpl(userName)) {
                return null;
            }
            return userName;
        }

        private boolean isValidUserImpl(String userName) {
            if (userName == null) {
                return false;
            }
            return CurrentUsersList.this.userManager.getUserByName(userName) != null;
        }

        public String getIpAddress() {
            return CurrentUsersList.this.nvl(this.jiraUserSession.getIpAddress());
        }

        public long getRequestCount() {
            return this.jiraUserSession.getRequestCount();
        }

        public String getCreationTime() {
            return CurrentUsersList.this.toDateStr(this.jiraUserSession.getCreationTime());
        }

        public String getLastAccessTime() {
            return CurrentUsersList.this.toDateStr(this.jiraUserSession.getLastAccessTime());
        }

        public String getType() {
            return this.jiraUserSession.getType().name();
        }
    }
}

