/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.DCFeatureLicenseChecker;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldId;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

@WebSudoRequired
public class ConfigureCustomField
extends JiraWebActionSupport {
    private FieldId fieldId;
    private Long deleteFieldConfigSchemeId;
    private final FieldConfigSchemeManager schemeManager;
    private final FieldManager fieldManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final HelpUrls helpUrls;
    private final DCFeatureLicenseChecker licenseChecker;
    private final PageBuilderService pageBuilderService;
    private final FeatureManager featureManager;

    public ConfigureCustomField(FieldConfigSchemeManager schemeManager, FieldManager fieldManager, ManagedConfigurationItemService managedConfigurationItemService, HelpUrls helpUrls, DCFeatureLicenseChecker licenseChecker, PageBuilderService pageBuilderService, FeatureManager featureManager) {
        this.schemeManager = schemeManager;
        this.fieldManager = fieldManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.helpUrls = helpUrls;
        this.licenseChecker = licenseChecker;
        this.pageBuilderService = pageBuilderService;
        this.featureManager = featureManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.processResources();
        return super.doDefault();
    }

    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        this.processResources();
        return "success";
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDelete() {
        this.processResources();
        return "delete";
    }

    public List<FieldConfigScheme> getConfigs() {
        if (this.getField() != null) {
            return this.schemeManager.getConfigSchemesForField(this.getField());
        }
        return null;
    }

    public ConfigurableField<?> getField() {
        return this.fieldManager.getConfigurableField(this.getFieldId());
    }

    @ActionViewData
    public String getFieldId() {
        return this.fieldId.toFullId();
    }

    public void setFieldId(String fieldId) {
        this.fieldId = FieldId.fromFullId(fieldId);
    }

    @ActionViewData
    public boolean isSystemField() {
        return this.fieldId.isSystemField();
    }

    @ActionViewData
    public Long getCustomFieldId() {
        return this.fieldId.isCustomField() ? Long.valueOf(this.fieldId.getCustomFieldId()) : null;
    }

    public void setCustomFieldId(Long customFieldId) {
        if (customFieldId != null) {
            this.fieldId = FieldId.fromCustomFieldId(customFieldId);
        }
    }

    public boolean isFieldManaged() {
        return Optional.ofNullable(this.getManagedConfigurationItem()).map(ManagedConfigurationItem::isManaged).orElse(false);
    }

    public boolean isFieldConfigureAvailable() {
        return !this.isFieldLocked() && !this.isDefaultValueDisabled();
    }

    private boolean isFieldLocked() {
        ManagedConfigurationItem managedConfigurationItem = this.getManagedConfigurationItem();
        if (managedConfigurationItem != null) {
            return !this.managedConfigurationItemService.doesUserHavePermission(this.getLoggedInUser(), managedConfigurationItem);
        }
        return false;
    }

    private boolean isDefaultValueDisabled() {
        if (this.fieldId.isSystemField()) {
            return !this.isLicensedForDefaultValues();
        }
        return false;
    }

    private boolean isLicensedForDefaultValues() {
        return this.licenseChecker.isEnabled(JiraFeatureFlagRegistrar.DEFAULT_VALUES_FOR_SYSTEM_FIELDS);
    }

    public String getManagedFieldDescriptionKey() {
        return Optional.ofNullable(this.getManagedConfigurationItem()).map(ManagedConfigurationItem::getDescriptionI18nKey).orElse("");
    }

    @Nullable
    private ManagedConfigurationItem getManagedConfigurationItem() {
        if (this.getField() instanceof CustomField) {
            return this.managedConfigurationItemService.getManagedCustomField((CustomField)this.getField());
        }
        return null;
    }

    @ActionViewData(value="delete")
    public HelpUrl getDocumentationUrl() {
        return this.helpUrls.getUrl("customfields.configcustomfield");
    }

    @ActionViewData(value="delete")
    public Long getFieldConfigSchemeId() {
        return this.deleteFieldConfigSchemeId;
    }

    public void setFieldConfigSchemeId(Long value) {
        this.deleteFieldConfigSchemeId = value;
    }

    @ActionViewData(value="delete")
    public String getFieldConfigSchemeName() {
        return Optional.ofNullable(this.schemeManager.getFieldConfigScheme(this.deleteFieldConfigSchemeId)).map(FieldConfigScheme::getName).orElse(null);
    }

    @ActionViewData
    public String getXsrfToken() {
        return super.getXsrfToken();
    }

    @ActionViewData
    public String getReturnUrl() {
        return super.getReturnUrl();
    }

    @ActionViewData(value="delete")
    public String getReturnUrlDeleted() {
        String returnUrl = this.getReturnUrl();
        if (returnUrl == null) {
            return null;
        }
        return this.getUriValidator().getSafeUri(JiraUrl.constructBaseUrl((HttpServletRequest)this.getHttpRequest()), returnUrl + "&deletedContext=" + this.urlEncode(this.getFieldConfigSchemeName()));
    }

    public boolean getIsUiLegacy() {
        return !this.featureManager.isEnabled(JiraFeatureFlagRegistrar.CUSTOM_FIELDS_CONFIGURE_MODERN_UI);
    }

    private void processResources() {
        boolean isModernUI;
        this.includeResourcesForDelete();
        boolean bl = isModernUI = !this.getIsUiLegacy();
        if (isModernUI) {
            this.pageBuilderService.assembler().resources().requireContext("customFieldsConfigurePageModernUi");
        }
    }

    private void includeResourcesForDelete() {
        this.pageBuilderService.assembler().resources().requireContext("jira.webresources:delete-field-config");
    }
}

