/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuesecurity;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelService;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class EditLevel
extends JiraWebActionSupport {
    private Long levelId;
    private Long schemeId;
    private IssueSecurityLevel level;
    private String name;
    private String description;
    private IssueSecurityLevelManager levelManager;
    private IssueSecurityLevelService issueSecurityLevelService;

    public IssueSecurityLevelService getIssueSecurityLevelService() {
        return this.issueSecurityLevelService;
    }

    public IssueSecurityLevelManager getLevelManager() {
        return this.levelManager;
    }

    public EditLevel(IssueSecurityLevelManager levelManager, IssueSecurityLevelService issueSecurityLevelService) {
        this.levelManager = levelManager;
        this.issueSecurityLevelService = issueSecurityLevelService;
    }

    public String getRedirectURL() {
        return "EditIssueSecurities.jspa";
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.level = this.getLevel();
        this.name = this.level.getName();
        this.description = this.level.getDescription();
        return "input";
    }

    public IssueSecurityLevel getLevel() throws GenericEntityException {
        if (this.level == null) {
            this.level = this.getLevelManager().getSecurityLevel(this.levelId.longValue());
        }
        return this.level;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doExecute() throws Exception {
        IssueSecurityLevelService.UpdateValidationResult vr = this.issueSecurityLevelService.validateUpdate(this.getLoggedInUser(), this.getLevel(), this.getName(), this.getDescription());
        if (vr.isValid()) {
            ServiceOutcome serviceOutcome = this.issueSecurityLevelService.update(this.getLoggedInUser(), vr);
        } else {
            this.addErrorCollection(vr.getErrors());
        }
        return this.getRedirect("EditIssueSecurities!default.jspa?schemeId=" + this.getSchemeId());
    }

    public Long getLevelId() {
        return this.levelId;
    }

    public void setLevelId(Long levelId) {
        this.levelId = levelId;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public void setLevel(IssueSecurityLevel level) {
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

