/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueTypeSchemeService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.archiving.ArchivedIssueSearchService;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigPredicate;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.web.action.admin.issuetypes.ConfigureOptionScheme;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.action.admin.issuetypes.ProjectIssueTypeSchemeHelper;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

@WebSudoRequired
public class ConfigureIssueTypeOptionScheme
extends ConfigureOptionScheme {
    private final ComponentFactory componentFactory;
    private final ArchivedIssueSearchService archivedIssueSearchService;
    private List<Project> associatedProjects;

    public ConfigureIssueTypeOptionScheme(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, ConstantsManager constantsManager, IssueManager issueManager, ComponentFactory factory, EventPublisher eventPublisher, IssueTypeSchemeService issueTypeSchemeService, ArchivedIssueSearchService archivedIssueSearchService) {
        super(configSchemeManager, issueTypeSchemeManager, fieldManager, optionSetManager, manageableOptionType, bulkMoveOperation, constantsManager, issueManager, eventPublisher, issueTypeSchemeService);
        this.componentFactory = factory;
        this.archivedIssueSearchService = archivedIssueSearchService;
    }

    @Override
    protected void doValidation() {
        List<Issue> archivedIssues;
        super.doValidation();
        if (CollectionUtils.exists((Collection)this.issueTypeSchemeManager.getAllSchemes(), (Predicate)new FieldConfigPredicate(this.getSchemeId(), this.getName()))) {
            this.addError("name", this.getText("admin.errors.issuetypes.duplicate.name"));
        }
        if (this.getSelectedOptions() != null && this.getSelectedOptions().length > 0) {
            boolean hasNormalIssueType = false;
            for (int i = 0; i < this.getSelectedOptions().length; ++i) {
                String id = this.getSelectedOptions()[i];
                IssueType issueType = this.constantsManager.getIssueType(id);
                if (issueType.isSubTask()) continue;
                hasNormalIssueType = true;
                break;
            }
            if (!hasNormalIssueType) {
                this.addErrorMessage(this.getText("admin.errors.issuetypes.must.select.standard.issue.type"));
            }
        }
        if (!(archivedIssues = this.getAffectedArchivedIssues()).isEmpty()) {
            this.addArchivedIssuesAffectedErrorMessage(archivedIssues);
        }
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        List<String> obsoleteOptionsIds;
        List<Long> projectIds = this.getAssociatedProjectsIds();
        if (!projectIds.isEmpty() && !(obsoleteOptionsIds = this.getObsoleteOptionsIds()).isEmpty()) {
            ArrayList<Issue> affectedIssues = new ArrayList<Issue>(this.issueTypeSchemeService.getIssuesMatchingTypesInProjects(this.getLoggedInUser(), projectIds, obsoleteOptionsIds));
            List<Issue> archivedIssues = this.getAffectedArchivedIssues();
            affectedIssues.addAll(archivedIssues);
            if (!affectedIssues.isEmpty()) {
                this.configScheme = new FieldConfigScheme.Builder(this.getConfigScheme()).setName(this.getName()).setDescription(this.getDescription()).toFieldConfigScheme();
                ArrayList<String> optionIds = new ArrayList<String>(Arrays.asList(this.getSelectedOptions()));
                return this.migrateIssues(this, affectedIssues, optionIds);
            }
        }
        return super.doExecute();
    }

    public List<Project> getUsedIn() {
        if (this.associatedProjects == null) {
            ProjectIssueTypeSchemeHelper helper = this.componentFactory.createObject(ProjectIssueTypeSchemeHelper.class, new Object[0]);
            this.associatedProjects = helper.getProjectsUsingScheme(this.getConfigScheme());
        }
        return this.associatedProjects;
    }

    @Override
    public boolean isAllowEditOptions() {
        return !this.issueTypeSchemeManager.getDefaultIssueTypeScheme().getId().equals(this.getSchemeId());
    }

    private List<String> getObsoleteOptionsIds() {
        Collection<Option> newOptions = this.getNewOptions();
        Collection<Option> originalOptions = this.getOriginalOptions();
        return originalOptions.stream().filter(originalOption -> !newOptions.contains(originalOption)).map(Option::getId).collect(Collectors.toList());
    }

    private List<Long> getAssociatedProjectsIds() {
        return this.getConfigScheme().getAssociatedProjectObjects().stream().map(Project::getId).collect(Collectors.toList());
    }

    private List<Issue> getAffectedArchivedIssues() {
        return this.archivedIssueSearchService.getArchivedIssuesMatchingTypesInProjects(this.getAssociatedProjectsIds(), this.getObsoleteOptionsIds());
    }

    private void addArchivedIssuesAffectedErrorMessage(List<Issue> archivedIssues) {
        List namesOfAffectedIssueTypes = archivedIssues.stream().map(Issue::getIssueType).filter(Objects::nonNull).map(IssueConstant::getNameTranslation).distinct().collect(Collectors.toList());
        if (namesOfAffectedIssueTypes.size() == 1) {
            this.addErrorMessage(this.getText("admin.errors.issuetypes.archived.issues.single", (String)namesOfAffectedIssueTypes.get(0)));
        } else {
            this.addErrorMessage(this.getText("admin.errors.issuetypes.archived.issues.multiple", String.join((CharSequence)", ", namesOfAffectedIssueTypes)));
        }
    }
}

