/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.permission;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.management.ProjectPermissionFeatureHelper;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.permission.SchemeAwarePermissionAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.atlassian.fugue.Option;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class DeletePermission
extends SchemeAwarePermissionAction {
    private Long id;
    private boolean confirmed = false;
    private final PermissionManager permissionManager;
    private final PermissionTypeManager permTypeManager;
    private final ProjectPermissionFeatureHelper projectPermissionFeatureHelper;

    public DeletePermission(PermissionManager permissionManager, PermissionTypeManager permTypeManager, ProjectPermissionFeatureHelper projectPermissionFeatureHelper) {
        this.permissionManager = permissionManager;
        this.permTypeManager = permTypeManager;
        this.projectPermissionFeatureHelper = projectPermissionFeatureHelper;
    }

    protected void doValidation() {
        if (this.id == null) {
            this.addErrorMessage(this.getText("admin.errors.permissions.specify.permission.to.delete"));
        }
        if (!this.confirmed) {
            this.addErrorMessage(this.getText("admin.errors.permissions.confirm.deletion"));
        }
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (!this.projectPermissionFeatureHelper.useOldProjectPermissionPage().booleanValue()) {
            return this.getRedirect(this.projectPermissionFeatureHelper.getNewEditPermissionUrl(this.getSchemeId()));
        }
        return super.doDefault();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        ComponentAccessor.getPermissionSchemeManager().deleteEntity(this.getId());
        return this.getRedirect(this.getRedirectURL());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    private GenericValue getPermission() throws GenericEntityException {
        return ComponentAccessor.getPermissionSchemeManager().getEntity(this.id);
    }

    public String getPermissionDisplayName() throws GenericEntityException {
        String type = this.getPermission().getString("type");
        SchemeType schemeType = this.getType(type);
        if (schemeType != null) {
            return schemeType.getDisplayName();
        }
        return type;
    }

    public String getPermissionParameter() throws GenericEntityException {
        GenericValue permissionGV = this.getPermission();
        String param = permissionGV.getString("parameter");
        String type = permissionGV.getString("type");
        SecurityType securityType = this.permTypeManager.getSecurityType(type);
        if (securityType != null) {
            return securityType.getArgumentDisplay(param);
        }
        return "";
    }

    public String getPermissionName() throws GenericEntityException {
        String permissionKey = this.getPermission().getString("permissionKey");
        Option permission = this.permissionManager.getProjectPermission(new ProjectPermissionKey(permissionKey));
        return permission.isDefined() ? ((ProjectPermission)permission.get()).getNameI18nKey() : permissionKey;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    @Override
    public String getRedirectURL() {
        if (this.getSchemeId() == null) {
            return "ViewPermissionSchemes.jspa";
        }
        return "EditPermissions!default.jspa?schemeId=" + this.getSchemeId();
    }
}

