/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.permission;

import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.permission.ProjectPermissionSchemeHelper;
import com.atlassian.jira.permission.management.ProjectPermissionFeatureHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.admin.permission.SchemeAwarePermissionAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class OldEditPermissions
extends SchemeAwarePermissionAction {
    private final PermissionManager permissionManager;
    private final ProjectPermissionSchemeHelper helper;
    private final ProjectPermissionFeatureHelper projectPermissionFeatureHelper;
    private String usersGroupsRolesHeaderText;
    private List<Project> projects;

    public OldEditPermissions(PermissionManager permissionManager, ProjectPermissionSchemeHelper helper, ProjectPermissionFeatureHelper projectPermissionFeatureHelper) {
        this.permissionManager = permissionManager;
        this.helper = helper;
        this.projectPermissionFeatureHelper = projectPermissionFeatureHelper;
    }

    public Collection<ProjectPermission> getProjectPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.PROJECTS);
    }

    public Collection<ProjectPermission> getIssuePermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.ISSUES);
    }

    public Collection<ProjectPermission> getVotersAndWatchersPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.VOTERS_AND_WATCHERS);
    }

    public Collection<ProjectPermission> getTimeTrackingPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.TIME_TRACKING);
    }

    public Collection<ProjectPermission> getCommentsPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.COMMENTS);
    }

    public Collection<ProjectPermission> getAttachmentsPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.ATTACHMENTS);
    }

    public Collection<ProjectPermission> getOtherPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.OTHER);
    }

    public String getI18nUsersGroupsRolesHeader() {
        if (this.usersGroupsRolesHeaderText == null) {
            this.usersGroupsRolesHeaderText = this.getText("admin.common.words.users.groups.roles");
        }
        return this.usersGroupsRolesHeaderText;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (!this.projectPermissionFeatureHelper.useOldProjectPermissionPage().booleanValue()) {
            return this.getRedirect(this.projectPermissionFeatureHelper.getNewEditPermissionUrl(this.getSchemeId()));
        }
        return super.doDefault();
    }

    public List<GenericValue> getPermissions(String permissionKey) throws GenericEntityException {
        return this.getSchemeManager().getEntities(this.getScheme(), permissionKey);
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            Scheme permissionScheme = this.getSchemeObject();
            this.projects = this.helper.getSharedProjects(permissionScheme);
        }
        return this.projects;
    }
}

