/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.permission;

import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissionSchemeHelper;
import com.atlassian.jira.permission.management.ProjectPermissionFeatureHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@WebSudoRequired
public class ProjectPermissions
extends JiraWebActionSupport {
    private static final ObjectMapper OBJECT_MAPPER;
    private final PageBuilderService pageBuilderService;
    private final PermissionSchemeManager permissionSchemeManager;
    private final ProjectPermissionSchemeHelper helper;
    private final ProjectPermissionFeatureHelper projectPermissionFeatureHelper;
    private final SchemeManager schemeManager;
    private long schemeId = 0L;

    public ProjectPermissions(PageBuilderService pageBuilderService, PermissionSchemeManager permissionSchemeManager, ProjectPermissionSchemeHelper helper, ProjectPermissionFeatureHelper projectPermissionFeatureHelper, SchemeManagerFactory schemeManagerFactory) {
        this.pageBuilderService = pageBuilderService;
        this.permissionSchemeManager = permissionSchemeManager;
        this.helper = helper;
        this.projectPermissionFeatureHelper = projectPermissionFeatureHelper;
        this.schemeManager = schemeManagerFactory.getSchemeManager("PermissionScheme");
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        Scheme scheme = this.permissionSchemeManager.getSchemeObject(Long.valueOf(this.schemeId));
        if (scheme == null) {
            return this.getRedirect("ViewPermissionSchemes.jspa?invalidPermissionSchemeRequested=" + this.schemeId);
        }
        if (this.projectPermissionFeatureHelper.useOldProjectPermissionPage().booleanValue()) {
            return this.getRedirect(this.projectPermissionFeatureHelper.getOldEditPermissionUrl(this.getSchemeId()));
        }
        this.tagMauEventAccordingToAssociatedProjects(scheme);
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:projectpermissions");
        this.pageBuilderService.assembler().data().requireData("permissionSchemeId", (Number)this.schemeId);
        this.pageBuilderService.assembler().data().requireData("sharedProjects", writer -> OBJECT_MAPPER.writeValue(writer, this.getUsedIn()));
        return "success";
    }

    private void tagMauEventAccordingToAssociatedProjects(Scheme scheme) {
        Set projectTypeKeys;
        MauApplicationKey mauApplicationKey = MauApplicationKey.family();
        List projects = this.schemeManager.getProjects(scheme);
        if (!projects.isEmpty() && (projectTypeKeys = projects.stream().map(project -> project.getProjectTypeKey()).collect(Collectors.toSet())).size() == 1) {
            mauApplicationKey = MauApplicationKey.forProjectTypeKey((ProjectTypeKey)((ProjectTypeKey)projectTypeKeys.iterator().next()));
        }
        this.tagMauEventWithApplication(mauApplicationKey);
    }

    public long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(long schemeId) {
        this.schemeId = schemeId;
    }

    private List<ProjectBean> getUsedIn() {
        Scheme permissionScheme = this.permissionSchemeManager.getSchemeObject(Long.valueOf(this.schemeId));
        return this.helper.getSharedProjects(permissionScheme).stream().map(ProjectBean::new).collect(Collectors.toList());
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        OBJECT_MAPPER = mapper;
    }

    private static class ProjectBean {
        private final Long id;
        private final String key;
        private final String name;
        private final boolean archived;

        public ProjectBean(Project project) {
            this.id = project.getId();
            this.key = project.getKey();
            this.name = project.getName();
            this.archived = project.isArchived();
        }

        public Long getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public boolean isArchived() {
            return this.archived;
        }
    }
}

