/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.resolutions;

import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.constants.AbstractEditConstant;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;

@WebSudoRequired
public class EditResolution
extends AbstractEditConstant<Resolution> {
    private final ResolutionManager resolutionManager;

    public EditResolution(ResolutionManager resolutionManager) {
        this.resolutionManager = resolutionManager;
    }

    @Override
    protected String getConstantEntityName() {
        return "Resolution";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.resolution.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "resolution";
    }

    @Override
    protected Resolution getConstant(String id) {
        return this.getConstantsManager().getResolution(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewResolutions.jspa";
    }

    @Override
    protected Collection<Resolution> getConstants() {
        return this.getConstantsManager().getResolutions();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshResolutions();
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        Resolution resolution = this.resolutionManager.getResolution(this.id);
        this.resolutionManager.editResolution(resolution, this.name, this.description);
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect(this.getRedirectPage());
    }
}

