/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.browser;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.plugin.userformat.UserFormatter;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.archiving.ArchivedProjectManager;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.project.type.BrowseProjectTypeManager;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeyFormatter;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.InternalProjectPermissionHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.velocity.NumberTool;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.browser.ProjectDataForArchivingCollector;
import com.atlassian.jira.web.action.browser.ProjectTypeBean;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.query.Query;
import com.atlassian.seraph.util.RedirectUtils;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.Collector;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ServletActionContext;

public class BrowseProjects
extends JiraWebActionSupport {
    private static final ObjectMapper OBJECT_MAPPER;
    private final UserProjectHistoryManager projectHistoryManager;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final SimpleLinkManager simpleLinkManager;
    private final WebInterfaceManager webInterfaceManager;
    private final PageBuilderService pageBuilderService;
    private final UserFormatter userFormatter;
    private final ProjectTypeManager projectTypeManager;
    private final BrowseProjectTypeManager browseProjectTypeManager;
    private final ArchivedProjectManager archivedProjectManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final SearchProvider searchProvider;
    private final ArchivingLicenseCheck archivingLicenseCheck;
    private final InternalProjectPermissionHelper projectPermissionHelper;
    private static final String ALL = "all";
    private static final String NONE = "none";
    private static final String RECENT = "recent";
    private static final String ARCHIVED = "archived";
    private final Long PROJECT_DEFAULT_AVATAR_ID;
    private final Supplier<List<ProjectCategoryBean>> categories = Suppliers.memoize((Supplier)new Supplier<List<ProjectCategoryBean>>(){

        public List<ProjectCategoryBean> get() {
            Collection<Project> noCategoryProjects;
            ArrayList categories = Lists.newArrayList();
            Collection projectCategories = BrowseProjects.this.projectManager.getAllProjectCategories();
            for (ProjectCategory projectCategory : projectCategories) {
                Collection<Project> projects;
                if (projectCategory == null || (projects = BrowseProjects.this.projectPermissionHelper.getBrowsableProjectsInCategory(BrowseProjects.this.getLoggedInUser(), projectCategory)).isEmpty()) continue;
                categories.add(new ProjectCategoryBean(projectCategory));
            }
            if (!categories.isEmpty() && !(noCategoryProjects = BrowseProjects.this.projectPermissionHelper.getBrowsableProjectsInCategory(BrowseProjects.this.getLoggedInUser(), null)).isEmpty()) {
                categories.add(new ProjectCategoryBean(BrowseProjects.this.getText("browse.projects.none"), BrowseProjects.this.getText("browse.projects.none.desc"), BrowseProjects.NONE));
            }
            if (!((List)BrowseProjects.this.recentProjects.get()).isEmpty()) {
                categories.add(new ProjectCategoryBean(BrowseProjects.this.getText("browse.projects.recent"), BrowseProjects.this.getText("browse.projects.recent.desc"), BrowseProjects.RECENT));
            }
            if (BrowseProjects.this.archivingLicenseCheck.isLicensedForProjectArchiving()) {
                categories.add(new ProjectCategoryBean(BrowseProjects.this.getText("browse.projects.archived"), BrowseProjects.this.getText("browse.projects.archived.desc"), BrowseProjects.ARCHIVED));
            }
            categories.add(0, new ProjectCategoryBean(BrowseProjects.this.getText("browse.projects.category.all"), BrowseProjects.this.getText("browse.projects.category.all.desc"), BrowseProjects.ALL));
            return ImmutableList.copyOf((Collection)categories);
        }
    });
    private Supplier<List<ProjectBean>> projects = Suppliers.memoize((Supplier)new Supplier<List<ProjectBean>>(){

        public List<ProjectBean> get() {
            Map<Long, Long> projectToCount;
            Map<Long, Long> projectToUpdated;
            Stream<Object> projectStream;
            boolean isAdminMode = BrowseProjects.this.isAdminMode();
            ApplicationUser loggedInUser = BrowseProjects.this.getLoggedInUser();
            if (isAdminMode) {
                projectStream = BrowseProjects.this.permissionManager.hasPermission(0, loggedInUser) ? BrowseProjects.this.projectManager.getProjects().stream() : BrowseProjects.this.permissionManager.getProjects(ProjectPermissions.ADMINISTER_PROJECTS, loggedInUser).stream();
                ProjectDataForArchivingCollector collector = BrowseProjects.this.getStatsForArchiving();
                projectToUpdated = collector.getMapToUpdatedDate();
                projectToCount = collector.getMapToIssueCount();
            } else {
                projectStream = BrowseProjects.this.projectPermissionHelper.getBrowsableProjects(loggedInUser).stream();
                projectToUpdated = Collections.emptyMap();
                projectToCount = Collections.emptyMap();
            }
            return Stream.concat(this.getActiveProjectsBeans(isAdminMode, projectToUpdated, projectToCount, projectStream), this.getArchivedProjectsBeans(isAdminMode)).collect(Collectors.toList());
        }

        private Stream<ProjectBean> getActiveProjectsBeans(boolean isAdminMode, Map<Long, Long> projectToUpdated, Map<Long, Long> projectToCount, Stream<Project> projectStream) {
            return projectStream.map(project -> this.toActiveProjectBean((Project)project, isAdminMode, ((List)BrowseProjects.this.recentProjects.get()).contains(project), projectToUpdated, projectToCount));
        }

        private ProjectBean toActiveProjectBean(Project project, boolean isAdminMode, boolean isRecent, Map<Long, Long> projectToUpdated, Map<Long, Long> projectToCount) {
            if (isAdminMode) {
                return new AdminProjectBean(project, isRecent, projectToUpdated.get(project.getId()), BrowseProjects.this.toDisplayableString(projectToCount.get(project.getId())));
            }
            return new ProjectBean(project, isRecent);
        }

        private Stream<ArchivedProjectBean> getArchivedProjectsBeans(boolean isAdminMode) {
            ApplicationUser loggedInUser = BrowseProjects.this.getLoggedInUser();
            boolean isAdmin = BrowseProjects.this.permissionManager.hasPermission(0, loggedInUser);
            return BrowseProjects.this.projectManager.getArchivedProjects().stream().filter(project -> isAdminMode && isAdmin || (isAdminMode ? BrowseProjects.this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, loggedInUser) : BrowseProjects.this.projectPermissionHelper.canUserBrowseProject((Project)project, loggedInUser))).map(project -> this.toArchivedProjectBean((Project)project, isAdminMode));
        }

        private ArchivedProjectBean toArchivedProjectBean(Project project, boolean isAdminMode) {
            if (isAdminMode) {
                return new AdminArchivedProjectBean(project, ((List)BrowseProjects.this.recentProjects.get()).contains(project), BrowseProjects.this.archivedProjectManager.getArchivedBy(project).orElse(null), BrowseProjects.this.archivedProjectManager.getArchivedTimestamp(project));
            }
            return new ArchivedProjectBean(project, ((List)BrowseProjects.this.recentProjects.get()).contains(project), BrowseProjects.this.archivedProjectManager.getArchivedBy(project).orElse(null), BrowseProjects.this.archivedProjectManager.getArchivedTimestamp(project));
        }
    });
    private final Supplier<Map<String, ProjectTypeBean>> projectTypes = Suppliers.memoize((Supplier)new Supplier<Map<String, ProjectTypeBean>>(){

        public Map<String, ProjectTypeBean> get() {
            return this.getProjectTypeBeans();
        }

        private Map<String, ProjectTypeBean> getProjectTypeBeans() {
            ArrayList projectTypes = Lists.newArrayList((Iterable)BrowseProjects.this.projectTypeManager.getAllProjectTypes());
            projectTypes.add(BrowseProjects.this.projectTypeManager.getInaccessibleProjectType());
            return projectTypes.stream().map(ProjectTypeBean::create).collect(Collectors.toMap(ProjectTypeBean::getKey, projectTypeBean -> projectTypeBean));
        }
    });
    private final Supplier<List<Project>> recentProjects = Suppliers.memoize((Supplier)new Supplier<List<Project>>(){

        public List<Project> get() {
            return ImmutableList.copyOf((Collection)BrowseProjects.this.projectHistoryManager.getProjectHistoryWithPermissionChecks(10, BrowseProjects.this.getLoggedInUser()));
        }
    });
    private String selectedCategory;
    private String selectedProjectType;
    private final Supplier<List<ProjectTypeBean>> availableProjectTypes = Suppliers.memoize((Supplier)new Supplier<List<ProjectTypeBean>>(){

        public List<ProjectTypeBean> get() {
            List allProjectTypes = BrowseProjects.this.convertToProjectTypeBeans(BrowseProjects.this.browseProjectTypeManager.getAllProjectTypes(BrowseProjects.this.getLoggedInUser()));
            allProjectTypes.add(0, ProjectTypeBean.create(BrowseProjects.ALL, BrowseProjects.this.getText("browse.projects.all.project.type")));
            return allProjectTypes;
        }
    });

    private String toDisplayableString(Long aLong) {
        return aLong == null ? null : new NumberTool(this.getI18nHelper().getLocale()).format((Object)aLong.doubleValue());
    }

    private ProjectDataForArchivingCollector getStatsForArchiving() {
        Query q = JqlQueryBuilder.newBuilder().buildQuery();
        ProjectDataForArchivingCollector collector = new ProjectDataForArchivingCollector();
        try {
            this.searchProvider.search(SearchQuery.create((Query)q, null).overrideSecurity(true), (Collector)collector);
        }
        catch (SearchException e) {
            throw new RuntimeException();
        }
        return collector;
    }

    private List<ProjectTypeBean> convertToProjectTypeBeans(List<ProjectType> projectTypes) {
        return projectTypes.stream().map(this::toBean).collect(Collectors.toList());
    }

    private ProjectTypeBean toBean(ProjectType projectType) {
        return ProjectTypeBean.create(projectType);
    }

    public BrowseProjects(UserProjectHistoryManager projectHistoryManager, ProjectManager projectManager, PermissionManager permissionManager, SimpleLinkManager simpleLinkManager, WebInterfaceManager webInterfaceManager, AvatarManager avatarManager, PageBuilderService pageBuilderService, UserFormats userFormats, ProjectTypeManager projectTypeManager, BrowseProjectTypeManager browseProjectTypeManager, ArchivedProjectManager archivedProjectManager, GlobalPermissionManager globalPermissionManager, SearchProvider searchProvider, ArchivingLicenseCheck archivingLicenseCheck, InternalProjectPermissionHelper projectPermissionHelper) {
        this.projectHistoryManager = projectHistoryManager;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.simpleLinkManager = simpleLinkManager;
        this.webInterfaceManager = webInterfaceManager;
        this.pageBuilderService = pageBuilderService;
        this.userFormatter = userFormats.formatter("profileLink");
        this.projectTypeManager = projectTypeManager;
        this.browseProjectTypeManager = browseProjectTypeManager;
        this.archivedProjectManager = archivedProjectManager;
        this.globalPermissionManager = globalPermissionManager;
        this.searchProvider = searchProvider;
        this.archivingLicenseCheck = archivingLicenseCheck;
        this.projectPermissionHelper = projectPermissionHelper;
        this.PROJECT_DEFAULT_AVATAR_ID = avatarManager.getDefaultAvatarId(Avatar.Type.PROJECT);
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        this.tagMauEventWithApplication(MauApplicationKey.family());
        if (!((List)this.projects.get()).isEmpty()) {
            this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:browseprojects");
            this.pageBuilderService.assembler().resources().requireContext("jira.browse");
            this.pageBuilderService.assembler().resources().requireContext("jira.browse.projects");
            this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse:categories", this.getCategoriesJsonable());
            this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse:projects", this.getProjectsJsonable());
            this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse:projectTypes", this.getProjectTypesJsonable());
            this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse:selectedCategory", this.getSelectedCategory());
            this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse:availableProjectTypes", this.getAvailableProjectTypesJsonable());
            this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse:selectedProjectType", this.getSelectedProjectType());
            return super.doExecute();
        }
        return "error";
    }

    @ActionViewData(value="success")
    public Collection<SimpleLink> getOperationLinks() {
        return this.simpleLinkManager.getLinksForSection("system.browse.projects.operations", this.getLoggedInUser(), this.getJiraHelper());
    }

    private JiraHelper getJiraHelper() {
        HashMap params = Maps.newHashMap();
        return new JiraHelper(ServletActionContext.getRequest(), null, (Map)params);
    }

    @ActionViewData(value="success")
    public String getInfoPanelHtml() {
        StringBuilder sb = new StringBuilder();
        List webPanelDescriptors = this.webInterfaceManager.getDisplayableWebPanelDescriptors("webpanels.browse.projects.info-panels", Collections.emptyMap());
        for (final WebPanelModuleDescriptor webPanelDescriptor : webPanelDescriptors) {
            Option result = Option.option((Object)SafePluginPointAccess.call((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ((WebPanel)webPanelDescriptor.getModule()).getHtml(Collections.emptyMap());
                }
            }).getOrNull());
            if (!result.isDefined()) continue;
            sb.append((String)result.get());
        }
        return sb.toString();
    }

    @ActionViewData(value="error")
    public Collection<String> getErrorMessages() {
        ArrayList errors = Lists.newArrayList();
        if ("true".equals(this.getApplicationProperties().getString("jira.setup"))) {
            boolean hasProjects;
            boolean bl = hasProjects = !this.projectManager.getProjectObjects().isEmpty();
            if (this.getLoggedInUser() == null && hasProjects) {
                errors.add(this.getText("noprojects.notloggedin"));
                String loginLink = "<a href=\"" + RedirectUtils.getLinkLoginURL((HttpServletRequest)this.getHttpRequest()) + "\">" + this.getText("common.words.login.caps") + "</a>";
                String logInOrSignup = this.getText("noprojects.mustfirstlogin", loginLink);
                if (JiraUtils.isPublicMode()) {
                    logInOrSignup = this.getText("noprojects.mustfirstlogin", this.getText("noprojects.browse.signup", loginLink, "<a href=\"" + this.getHttpRequest().getContextPath() + "/secure/Signup!default.jspa\">", "</a>"));
                }
                errors.add(logInOrSignup);
            } else if (hasProjects) {
                errors.add(this.getText("noprojects.nopermissions"));
                if (this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
                    String linkToProjectsAdminPage = this.getHttpRequest().getContextPath() + "/secure/admin/ViewPermissionSchemes.jspa";
                    errors.add(this.getText("noprojects.viewallprojects.message", "<a href=\"" + linkToProjectsAdminPage + "\">", "</a>"));
                } else {
                    errors.add(this.getText("noprojects.nopermissions.contactadmin"));
                }
            } else {
                errors.add(this.getText("noprojects"));
                if (this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
                    errors.add(this.getText("noprojects.createprojectnow"));
                    errors.add("<a class=\"add-project-trigger aui-button aui-button-primary\" href=\"" + this.getHttpRequest().getContextPath() + "/secure/project/ViewProjects.jspa\">" + this.getText("noprojects.createprojectnow.link") + "</a>");
                } else {
                    errors.add(this.getText("noprojects.contactadmin.permissions", this.getAdministratorContactLink()));
                }
            }
        } else {
            errors.add(this.getText("noprojects.mustsetupfirst"));
            errors.add(this.getText("noprojects.createadmintocreateotheradmins"));
            errors.add("<a href=\"" + this.getHttpRequest().getContextPath() + "/secure/Setup!default.jspa\">" + this.getText("noprojects.setupjira.link") + "</a>");
        }
        return errors;
    }

    @ActionViewData
    public String getSelectedCategory() {
        return this.selectedCategory != null ? this.selectedCategory : ALL;
    }

    public String getSelectedProjectType() {
        return this.selectedProjectType != null ? this.selectedProjectType : ALL;
    }

    public void setSelectedProjectType(String selectedProjectType) {
        this.selectedProjectType = selectedProjectType;
    }

    public Jsonable getCategoriesJsonable() throws GenericEntityException {
        return this.getJsonable(this.categories.get());
    }

    public Jsonable getProjectsJsonable() {
        return this.getJsonable(this.projects.get());
    }

    public Jsonable getProjectTypesJsonable() {
        return this.getJsonable(this.projectTypes.get());
    }

    public Jsonable getAvailableProjectTypesJsonable() {
        return this.getJsonable(this.availableProjectTypes.get());
    }

    private Jsonable getJsonable(Object entityToTransform) {
        return writer -> OBJECT_MAPPER.writeValue(writer, entityToTransform);
    }

    private static String convertCategoryToDescription(ProjectCategory category) {
        String name = category.getName();
        String desc = category.getDescription();
        if (StringUtils.isBlank((CharSequence)desc)) {
            return name;
        }
        return name + " - " + desc;
    }

    public boolean hasDefaultAvatar(Project project) {
        Long avatarId = project.getAvatar().getId();
        return avatarId == null || avatarId.equals(this.PROJECT_DEFAULT_AVATAR_ID);
    }

    public void setSelectedCategory(String selectedCategory) {
        this.selectedCategory = selectedCategory;
    }

    public Supplier<List<ProjectTypeBean>> getAvailableProjectTypes() {
        return this.availableProjectTypes;
    }

    public boolean isAdmin() {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.getLoggedInUser());
    }

    public boolean isProjectAdmin(Project project) {
        return ComponentAccessor.getPermissionManager().hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, this.getLoggedInUser());
    }

    @ActionViewData
    public boolean isAdminMode() {
        HttpServletRequest request = this.getHttpRequest();
        return request.getRequestURI().contains("/secure/project/");
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        OBJECT_MAPPER = mapper;
    }

    public class ProjectCategoryBean {
        private final String name;
        private final String description;
        private final String id;

        public ProjectCategoryBean(ProjectCategory category) {
            this(category.getName(), BrowseProjects.convertCategoryToDescription(category), String.valueOf(category.getId()));
        }

        public ProjectCategoryBean(String name, String description, String id) {
            this.name = name;
            this.description = description;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getId() {
            return this.id;
        }
    }

    public class AdminArchivedProjectBean
    extends ArchivedProjectBean {
        private final boolean isAdmin;
        private final boolean isProjectAdmin;

        public AdminArchivedProjectBean(Project project, boolean recent, ApplicationUser archivedBy, Long archivedTimestamp) {
            super(project, recent, archivedBy, archivedTimestamp);
            this.isAdmin = BrowseProjects.this.isAdmin();
            this.isProjectAdmin = BrowseProjects.this.isProjectAdmin(project);
        }

        public boolean getAdmin() {
            return this.isAdmin;
        }

        public boolean getProjectAdmin() {
            return this.isProjectAdmin;
        }
    }

    public class ArchivedProjectBean
    extends ProjectBean {
        private final boolean archived;
        private final Long archivedTimestamp;
        private final String archivedBy;
        private final String archivedByUsername;
        private final boolean isArchivedByUserActive;

        public ArchivedProjectBean(Project project, boolean recent, ApplicationUser archivedBy, Long archivedTimestamp) {
            super(project, recent);
            this.archivedTimestamp = archivedTimestamp;
            if (archivedBy != null) {
                this.archivedBy = archivedBy.getDisplayName();
                this.archivedByUsername = archivedBy.getUsername();
                this.isArchivedByUserActive = archivedBy.isActive();
            } else {
                this.archivedBy = null;
                this.archivedByUsername = null;
                this.isArchivedByUserActive = false;
            }
            this.archived = project.isArchived();
        }

        public boolean isArchived() {
            return this.archived;
        }

        public Long getArchivedTimestamp() {
            return this.archivedTimestamp;
        }

        public String getArchivedBy() {
            return this.archivedBy;
        }

        public String getArchivedByUsername() {
            return this.archivedByUsername;
        }

        public boolean getIsArchivedByUserActive() {
            return this.isArchivedByUserActive;
        }
    }

    public class AdminProjectBean
    extends ProjectBean {
        private final Long lastUpdatedTimestamp;
        private final String issueCount;
        private final boolean isAdmin;
        private final boolean isProjectAdmin;

        public AdminProjectBean(Project project, boolean recent, Long lastUpdatedTimestamp, String issueCount) {
            super(project, recent);
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            this.issueCount = issueCount;
            this.isAdmin = BrowseProjects.this.isAdmin();
            this.isProjectAdmin = BrowseProjects.this.isProjectAdmin(project);
        }

        public Long getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public String getIssueCount() {
            return this.issueCount;
        }

        public boolean getAdmin() {
            return this.isAdmin;
        }

        public boolean getProjectAdmin() {
            return this.isProjectAdmin;
        }
    }

    public class ProjectBean {
        private final String key;
        private final String name;
        private final Long id;
        private final boolean hasDefaultAvatar;
        private final boolean recent;
        private final String lead;
        private final String leadUsername;
        private final boolean isLeadActive;
        private final Long projectCategoryId;
        private final String url;
        private final String projectTypeKey;
        private final String projectTypeName;

        public ProjectBean(Project project, boolean recent) {
            this(project.getKey(), project.getName(), project.getId(), this$0.hasDefaultAvatar(project), project.getProjectLead(), project.getProjectCategoryObject(), recent, project.getUrl(), project.getProjectTypeKey());
        }

        public ProjectBean(String key, String name, Long id, boolean hasDefaultAvatar, ApplicationUser lead, ProjectCategory projectCategory, boolean recent, String url, ProjectTypeKey projectTypeKey) {
            this.key = key;
            this.name = name;
            this.id = id;
            this.hasDefaultAvatar = hasDefaultAvatar;
            this.recent = recent;
            this.projectTypeKey = projectTypeKey.getKey();
            this.projectTypeName = ProjectTypeKeyFormatter.format((ProjectTypeKey)projectTypeKey);
            if (lead != null) {
                this.lead = lead.getDisplayName();
                this.leadUsername = lead.getUsername();
                this.isLeadActive = lead.isActive();
            } else {
                this.lead = null;
                this.leadUsername = null;
                this.isLeadActive = false;
            }
            this.url = url;
            this.projectCategoryId = projectCategory != null ? projectCategory.getId() : null;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public Long getId() {
            return this.id;
        }

        public boolean isHasDefaultAvatar() {
            return this.hasDefaultAvatar;
        }

        public boolean isRecent() {
            return this.recent;
        }

        @Nullable
        public String getLead() {
            return this.lead;
        }

        public String getUrl() {
            return this.url;
        }

        @Nullable
        public String getLeadUsername() {
            return this.leadUsername;
        }

        public boolean getIsLeadActive() {
            return this.isLeadActive;
        }

        @Nullable
        public Long getProjectCategoryId() {
            return this.projectCategoryId;
        }

        public String getProjectTypeKey() {
            return this.projectTypeKey;
        }

        public String getProjectTypeName() {
            return this.projectTypeName;
        }
    }
}

