/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.filter.FilterDeletionWarningViewProvider;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.filter.FilterLinkRenderer;
import com.atlassian.jira.web.action.filter.FilterOperationsAction;
import com.atlassian.jira.web.action.filter.FilterViewHelper;
import com.atlassian.jira.web.action.filter.FilterViewTabs;
import com.atlassian.jira.web.action.issue.SearchDescriptionEnabledAction;
import com.atlassian.jira.web.action.util.SearchRequestDisplayBean;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchAction;
import com.atlassian.jira.web.action.util.sharing.SharedEntitySearchViewHelper;
import com.atlassian.jira.web.ui.model.DropDownModel;
import com.atlassian.jira.web.ui.model.DropDownModelBuilder;
import com.atlassian.jira.web.ui.model.DropDownModelProvider;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

public class ManageFilters
extends SearchDescriptionEnabledAction
implements SharedEntitySearchAction,
FilterOperationsAction,
DropDownModelProvider<SearchRequestDisplayBean> {
    private static final FilterLinkRenderer ISSUE_NAVIGATOR_LINK_RENDERER = (id, name) -> String.format("<a id=\"filterlink_%1$d\" href=\"%2$s/issues/?filter=%1$d\">%3$s</a>", id, ActionContext.getRequest().getContextPath(), TextUtils.htmlEncode((String)name));
    protected static final String CONTENTONLY = "contentonly";
    private static final String KEY_NO_SEARCH = "common.sharing.searching.no.search.performed";
    private static final String KEY_NO_RESULTS = "filters.no.search.results";
    private static final String KEY_MANAGE_FILTERS_TAB = "jira.manage.filter.tab";
    private static final Logger log = LoggerFactory.getLogger(ManageFilters.class);
    private final SearchRequestService searchRequestService;
    protected final SearchRequestDisplayBean.Factory beanFactory;
    private final PageBuilderService pageBuilderService;
    private final FilterDeletionWarningViewProvider filterDeletionWarningViewProvider;
    private final UserPreferencesManager userPreferencesManager;
    private final FilterViewHelper filterHelper;
    private final FeatureManager featureManager;
    private final GlobalPermissionManager permissionManager;
    private String filterView;
    private String searchEmptyMessageKey = "filters.no.search.results";
    private List<SearchRequestDisplayBean> filters;
    private SharedEntitySearchViewHelper.SearchResult searchResults;
    private boolean contentOnly = false;
    private boolean searchContentOnly = false;
    private FilterViewTabs validTabs;
    private List<SearchRequestDisplayBean> subscribedFilters;

    public ManageFilters(JiraAuthenticationContext authCtx, IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, ShareTypeFactory shareTypeFactory, SearchRequestDisplayBean.Factory beanFactory, SearchService searchService, PageBuilderService pageBuilderService, FilterDeletionWarningViewProvider filterDeletionWarningViewProvider, UserPreferencesManager userPreferencesManager, FeatureManager featureManager, UserManager userManager, GlobalPermissionManager permissionManager) {
        super(issueSearcherManager, searchService);
        this.searchRequestService = searchRequestService;
        this.beanFactory = beanFactory;
        this.pageBuilderService = pageBuilderService;
        this.filterDeletionWarningViewProvider = filterDeletionWarningViewProvider;
        this.userPreferencesManager = userPreferencesManager;
        this.featureManager = featureManager;
        this.permissionManager = permissionManager;
        this.filterHelper = new FilterViewHelper(shareTypeFactory, authCtx, ActionContext.getRequest().getContextPath(), "ManageFilters.jspa?filterView=search", searchRequestService, featureManager, userManager, permissionManager);
        this.setReturnUrl("ManageFilters.jspa");
    }

    @Override
    public String getSearchName() {
        return this.getFilterHelper().getSearchName();
    }

    @Override
    public void setSearchName(String searchName) {
        this.getFilterHelper().setSearchName(searchName);
    }

    @Override
    public String getSearchOwnerUserName() {
        return this.getFilterHelper().getSearchOwnerUserName();
    }

    @Override
    public void setSearchOwnerUserName(String searchOwnerUserName) {
        this.getFilterHelper().setSearchOwnerUserName(searchOwnerUserName);
    }

    @Override
    public String getSearchShareType() {
        return this.getFilterHelper().getSearchShareType();
    }

    @Override
    public void setSearchShareType(String searchShareType) {
        this.getFilterHelper().setSearchShareType(searchShareType);
    }

    @Override
    public void setGroupShare(String groupShare) {
        this.getFilterHelper().setGroupShare(groupShare);
    }

    @Override
    public String getGroupShare() {
        return this.getFilterHelper().getGroupShare();
    }

    @Override
    public void setUserShare(String userShare) {
        this.getFilterHelper().setUserShare(userShare);
    }

    @Override
    public String getUserShare() {
        return this.getFilterHelper().getUserShare();
    }

    @Override
    public Long getPagingOffset() {
        return this.getFilterHelper().getPagingOffset();
    }

    @Override
    public void setProjectShare(String projectShare) {
        this.getFilterHelper().setProjectShare(projectShare);
    }

    @Override
    public String getProjectShare() {
        return this.getFilterHelper().getProjectShare();
    }

    @Override
    public void setRoleShare(String roleShare) {
        this.getFilterHelper().setRoleShare(roleShare);
    }

    @Override
    public String getRoleShare() {
        return this.getFilterHelper().getRoleShare();
    }

    @Override
    public void setPagingOffset(Long pagingOffset) {
        this.getFilterHelper().setPagingOffset(pagingOffset);
    }

    @Override
    public String getSortColumn() {
        return this.getFilterHelper().getSortColumn();
    }

    @Override
    public void setSortColumn(String sortColumn) {
        this.getFilterHelper().setSortColumn(sortColumn);
    }

    @Override
    public boolean isSortAscending() {
        return this.getFilterHelper().isSortAscending();
    }

    @Override
    public void setSortAscending(boolean sortAscending) {
        this.getFilterHelper().setSortAscending(sortAscending);
    }

    public String getFilterView() {
        return this.filterView;
    }

    public void setFilterView(String filterView) {
        this.filterView = filterView;
    }

    public List getFilters() {
        return this.filters;
    }

    protected void setFilters(List<SearchRequestDisplayBean> filters) {
        this.filters = filters;
    }

    public String getNextUrl() {
        return this.searchResults != null ? this.searchResults.getNextUrl() : null;
    }

    public String getPreviousUrl() {
        return this.searchResults != null ? this.searchResults.getPreviousUrl() : null;
    }

    public int getStartPosition() {
        return this.searchResults != null ? this.searchResults.getStartResultPosition() : -1;
    }

    public int getEndPosition() {
        return this.searchResults != null ? this.searchResults.getEndResultPosition() : -1;
    }

    public int getTotalResultCount() {
        return this.searchResults != null ? this.searchResults.getTotalResultCount() : -1;
    }

    public FilterViewHelper getFiltersViewHelper() {
        return this.getFilterHelper();
    }

    protected void setSearchResults(SharedEntitySearchViewHelper.SearchResult<SearchRequest> searchResults) {
        this.searchResults = searchResults;
    }

    @Override
    public DropDownModel getDropDownModel(SearchRequestDisplayBean displayBean, int listIndex) {
        DropDownModelBuilder builder = DropDownModelBuilder.builder();
        if (displayBean.canEdit()) {
            builder.setTopText(this.getText("common.words.operations"));
            builder.startSection().addItem(builder.item().setText(this.getText("managefilters.edit.filter")).setAttr("id", "edit_filter_" + displayBean.getId()).setAttr("class", "edit-filter").setAttr("href", this.toUrl(displayBean, "EditFilter!default.jspa", true)));
            if (displayBean.isCurrentOwner() || this.canCurrentUserEditAllFilters()) {
                builder.addItem(builder.item().setText(this.getText("managefilters.delete")).setAttr("id", "delete_" + displayBean.getId()).setAttr("class", "delete-filter").setAttr("href", this.toUrl(displayBean, "DeleteFilter!default.jspa", true)).setAttr("rel", "" + displayBean.getId()));
            }
            builder.endSection();
        }
        return builder.build();
    }

    private boolean canCurrentUserEditAllFilters() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS) && this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.getJiraServiceContext().getLoggedInApplicationUser());
    }

    protected String toUrl(SearchRequestDisplayBean filter, String page, boolean includeReturnUrl) {
        StringBuilder url = new StringBuilder(page);
        url.append("?filterId=").append(filter.getId());
        if (includeReturnUrl && StringUtils.isNotBlank((CharSequence)this.getReturnUrl())) {
            url.append("&returnUrl=").append(this.getReturnUrl());
        }
        return this.getUriValidator().getSafeUri("", url.toString());
    }

    public boolean canShowFavourite() {
        return this.isUserLoggedIn();
    }

    public boolean isUserLoggedIn() {
        return this.getLoggedInUser() != null;
    }

    public boolean canShowOwner() {
        return this.permissionManager.hasPermission(GlobalPermissionKey.USER_PICKER, this.getLoggedInUser());
    }

    public boolean isSearchRequested() {
        return ActionContext.getParameters().get("Search") != null;
    }

    public String getSearchEmptyMessageKey() {
        return this.searchEmptyMessageKey;
    }

    public boolean isTabShowing(String tab) {
        return this.getTabs().isValid(tab);
    }

    public boolean isFirstTab(String tab) {
        return this.getTabs().isFirst(tab);
    }

    private FilterViewTabs getTabs() {
        if (this.validTabs == null) {
            this.validTabs = !this.isUserLoggedIn() ? new FilterViewTabs((List<FilterViewTabs.Tab>)ImmutableList.of((Object)FilterViewTabs.POPULAR, (Object)FilterViewTabs.SEARCH), FilterViewTabs.POPULAR) : new FilterViewTabs((List<FilterViewTabs.Tab>)ImmutableList.of((Object)FilterViewTabs.FAVOURITES, (Object)FilterViewTabs.MY, (Object)FilterViewTabs.POPULAR, (Object)FilterViewTabs.SEARCH), FilterViewTabs.FAVOURITES);
        }
        return this.validTabs;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() {
        if (this.filterView != null) {
            this.setFilterViewToUserPreferences();
        } else {
            this.filterView = this.getFilterViewFromUserPreferences();
        }
        if (this.contentOnly && !this.getTabs().isValid(this.filterView)) {
            ServletActionContext.getResponse().setStatus(401);
            return "none";
        }
        FilterViewTabs.Tab filterViewTab = this.getTabs().getTabSafely(this.filterView);
        if (!this.contentOnly) {
            this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:managefilters");
            this.requireDeleteDialogResources();
        }
        if (filterViewTab != null) {
            this.filterView = filterViewTab.getName();
            if (FilterViewTabs.SEARCH == filterViewTab) {
                return this.executeSearchView();
            }
            if (FilterViewTabs.POPULAR == filterViewTab) {
                return this.executePopularView();
            }
            if (FilterViewTabs.MY == filterViewTab) {
                return this.executeMyView();
            }
            if (FilterViewTabs.FAVOURITES == filterViewTab) {
                return this.executeFavouriteView();
            }
            this.filterView = null;
        } else {
            this.filterView = null;
        }
        return "input";
    }

    public String doView() {
        return "success";
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public boolean isContentOnly() {
        return this.contentOnly;
    }

    public void setSearchContentOnly(boolean searchContentOnly) {
        this.searchContentOnly = searchContentOnly;
    }

    public boolean isSearchContentOnly() {
        return this.searchContentOnly;
    }

    public List<SearchRequestDisplayBean> getFiltersWithSubscriptions() {
        if (this.subscribedFilters == null) {
            if (this.filters == null) {
                this.subscribedFilters = Collections.emptyList();
            } else {
                this.subscribedFilters = new ArrayList<SearchRequestDisplayBean>();
                for (SearchRequestDisplayBean search : this.filters) {
                    if (search.getSubscriptionCount() <= 0L) continue;
                    this.subscribedFilters.add(search);
                }
            }
        }
        return this.subscribedFilters;
    }

    public int getFiltersWithSubscriptionsCount() {
        return this.getFiltersWithSubscriptions().size();
    }

    private String executeFavouriteView() {
        Collection favouriteFilters = this.searchRequestService.getFavouriteFilters(this.getLoggedInUser());
        this.filters = this.beanFactory.createDisplayBeans(favouriteFilters);
        return this.contentOnly ? CONTENTONLY : "success";
    }

    private String executeMyView() {
        Collection myFilters = this.searchRequestService.getOwnedFilters(this.getLoggedInUser());
        this.filters = this.beanFactory.createDisplayBeans(myFilters);
        return this.contentOnly ? CONTENTONLY : "success";
    }

    protected String executeSearchView() {
        this.filterView = FilterViewTabs.SEARCH.getName();
        this.setFilterViewToUserPreferences();
        boolean searchPerformed = this.isSearchRequested();
        if (searchPerformed) {
            JiraServiceContext ctx = this.getJiraServiceContext();
            this.searchResults = this.getFilterHelper().search(ctx);
            if (this.searchResults == null || ctx.getErrorCollection().hasAnyErrors()) {
                searchPerformed = false;
            } else {
                this.filters = this.beanFactory.createDisplayBeans(this.searchResults.getResults());
            }
        }
        if (!searchPerformed) {
            this.searchEmptyMessageKey = KEY_NO_SEARCH;
        }
        return this.contentOnly ? CONTENTONLY : "success";
    }

    private String executePopularView() {
        this.filterView = FilterViewTabs.POPULAR.getName();
        this.setFilterViewToUserPreferences();
        JiraServiceContext serviceContext = this.getJiraServiceContext();
        List<SearchRequest> results = this.getFilterHelper().getPopularFilters(serviceContext);
        if (results != null && !serviceContext.getErrorCollection().hasAnyErrors()) {
            this.filters = this.beanFactory.createDisplayBeans(results);
        }
        return this.contentOnly ? CONTENTONLY : "success";
    }

    private String getFilterViewFromUserPreferences() {
        if (!this.isUserLoggedIn()) {
            if (this.isSearchRequested()) {
                return FilterViewTabs.SEARCH.getName();
            }
            return null;
        }
        ExtendedPreferences preferences = this.userPreferencesManager.getExtendedPreferences(this.getLoggedInUser());
        return preferences.getText(KEY_MANAGE_FILTERS_TAB);
    }

    private void setFilterViewToUserPreferences() {
        if (!this.isUserLoggedIn()) {
            return;
        }
        ExtendedPreferences preferences = this.userPreferencesManager.getExtendedPreferences(this.getLoggedInUser());
        try {
            preferences.setText(KEY_MANAGE_FILTERS_TAB, this.filterView);
        }
        catch (AtlassianCoreException e) {
            log.warn("Exception setting user preference for the manage filters tab. The preference was not set.", (Throwable)e);
        }
    }

    public FilterLinkRenderer getFilterLinkRenderer() {
        return ISSUE_NAVIGATOR_LINK_RENDERER;
    }

    protected FilterViewHelper getFilterHelper() {
        return this.filterHelper;
    }

    protected void requireDeleteDialogResources() {
        this.filterDeletionWarningViewProvider.requireDefaultStyle(this.pageBuilderService.assembler().resources());
    }
}

