/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.issue.archiving.ArchivedIssueService;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.issue.AbstractViewIssue;
import com.opensymphony.util.TextUtils;
import java.util.Collection;

public class ArchiveIssue
extends AbstractViewIssue {
    private boolean confirm;
    private final ArchivedIssueService archivedIssueService;
    private final HelpUrls helpUrls;
    private ArchivedIssueService.ValidationResult validationResult;
    private Integer numberOfSubTasks;

    public ArchiveIssue(SubTaskManager subTaskManager, ArchivedIssueService archivedIssueService, ArchivingLicenseCheck archivingLicenseCheck, HelpUrls helpUrls) {
        super(subTaskManager);
        this.archivedIssueService = archivedIssueService;
        this.helpUrls = helpUrls;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST, RequestMethod.GET})
    protected String doExecute() throws Exception {
        ArchivedIssueService.ArchivingResult archivingResult;
        if (this.confirm && !(archivingResult = this.archivedIssueService.archiveIssue(this.validationResult)).isValid()) {
            this.addErrorCollection(archivingResult.getErrorCollection());
            return "error";
        }
        return this.returnComplete(this.getViewUrl());
    }

    private boolean isCurrentArchivedIssue(String returnUrl) {
        String key = this.getKey();
        return returnUrl.endsWith("browse/" + key) || returnUrl.contains("browse/" + key + "?");
    }

    @Override
    public String getViewUrl() {
        String returnUrl = this.getReturnUrl();
        if (TextUtils.stringSet((String)returnUrl) && !this.isCurrentArchivedIssue(returnUrl)) {
            return returnUrl;
        }
        if (TextUtils.stringSet((String)this.getViewIssueKey())) {
            return "/browse/" + this.getViewIssueKey();
        }
        return "/issues/";
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.doValidation();
        return "input";
    }

    protected void doValidation() {
        this.validationResult = this.archivedIssueService.validateArchiveIssue(this.getLoggedInUser(), this.getKey(), true);
        if (!this.validationResult.isValid()) {
            this.addErrorCollection(this.validationResult.getErrorCollection());
        }
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    @ActionViewData
    public Integer getNumberOfSubTasks() {
        if (this.numberOfSubTasks == null) {
            this.numberOfSubTasks = this.getIssueObject().getSubTaskObjects().size();
        }
        return this.numberOfSubTasks;
    }

    @ActionViewData
    public String getTargetUrl() {
        return this.getViewUrl();
    }

    @ActionViewData
    public boolean hasAnyErrors() {
        return super.hasAnyErrors();
    }

    @Override
    @ActionViewData
    public String getIssuePath() {
        return super.getIssuePath();
    }

    @ActionViewData
    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }

    @Override
    @ActionViewData
    public String getKey() {
        return super.getKey();
    }

    @ActionViewData
    public String getXsrfToken() {
        return super.getXsrfToken();
    }

    @ActionViewData
    public HelpUrl getDocumentationUrl() {
        return this.helpUrls.getUrl("issue.archive");
    }

    @ActionViewData
    public ProjectTypeKey getProjectType() {
        return super.getProjectObject().getProjectTypeKey();
    }
}

