/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.bc.issue.CloneIssueCommand;
import com.atlassian.jira.bc.issue.CloneIssueTaskContext;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentConfigManager;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.customfields.CloneOptionConfiguration;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.SummarySystemField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.issue.security.AssignIssueSecuritySchemeTaskContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.issue.CreateIssueDetails;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class CloneIssueDetails
extends CreateIssueDetails {
    private static final String BROWSE_ISSUE_PAGE_PREFIX = "/browse/";
    private static final String ATTACHMENT_ERROR = "attachment-error";
    private final transient ApplicationProperties applicationProperties;
    private final transient PermissionManager permissionManager;
    private final transient IssueLinkManager issueLinkManager;
    private final transient RemoteIssueLinkManager remoteIssueLinkManager;
    private final transient IssueLinkTypeManager issueLinkTypeManager;
    private final transient SubTaskManager subTaskManager;
    private final transient AttachmentManager attachmentManager;
    private final transient AttachmentConfigManager attachmentConfigManager;
    private final transient FieldManager fieldManager;
    private final transient IssueFactory issueFactory;
    private final transient TaskManager taskManager;
    private final transient TaskDescriptorBean.Factory taskBeanFactory;
    private transient IssueLinkType cloneIssueLinkType;
    private String cloneIssueLinkTypeName;
    private Issue originalIssue;
    private boolean cloneLinks;
    private boolean cloneSubTasks;
    private boolean cloneAttachments;
    private IssueService.CloneValidationResult cloneValidationResult;
    private Long taskId = null;
    private TaskDescriptor<CloneIssueCommand.CloneIssueResult> currentTaskDescriptor;
    private TaskDescriptorBean<CloneIssueCommand.CloneIssueResult> currentTask;

    public CloneIssueDetails(ApplicationProperties applicationProperties, PermissionManager permissionManager, IssueLinkManager issueLinkManager, RemoteIssueLinkManager remoteIssueLinkManager, IssueLinkTypeManager issueLinkTypeManager, SubTaskManager subTaskManager, AttachmentManager attachmentManager, AttachmentConfigManager attachmentConfigManager, FieldManager fieldManager, IssueCreationHelperBean issueCreationHelperBean, IssueFactory issueFactory, IssueService issueService, TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator, TaskManager taskManager, TaskDescriptorBean.Factory taskBeanFactory) {
        super(issueFactory, issueCreationHelperBean, issueService, temporaryAttachmentsMonitorLocator);
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.issueLinkManager = issueLinkManager;
        this.remoteIssueLinkManager = remoteIssueLinkManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.subTaskManager = subTaskManager;
        this.attachmentManager = attachmentManager;
        this.attachmentConfigManager = Objects.requireNonNull(attachmentConfigManager);
        this.fieldManager = fieldManager;
        this.issueFactory = issueFactory;
        this.taskManager = taskManager;
        this.taskBeanFactory = taskBeanFactory;
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.cloneSubTasks = true;
        this.cloneLinks = false;
        this.cloneAttachments = false;
        try {
            this.setOriginalIssue(this.getIssueObject(this.getIssue()));
            this.copySummaryFieldFromOriginalIssueToHolder();
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
        return "input";
    }

    public List<CustomFieldCloneOption> getCustomFieldCloneOptions() {
        ArrayList options = Lists.newArrayList();
        for (CustomField cf : this.getCustomFields(this.getOriginalIssue())) {
            CloneOptionConfiguration cloneOptionConfig = cf.getCustomFieldType().getCloneOptionConfiguration(cf, this.getOriginalIssue());
            if (!cloneOptionConfig.shouldDisplayOption()) continue;
            options.add(new CustomFieldCloneOption(cf.getId(), cloneOptionConfig.getOptionLabel(), cloneOptionConfig.isOptionSelectedByDefault()));
        }
        return options;
    }

    private void copySummaryFieldFromOriginalIssueToHolder() throws GenericEntityException {
        String summary = this.getOriginalIssue().getSummary();
        if (StringUtils.isNotBlank((CharSequence)summary)) {
            String clonePrefixProperties = this.applicationProperties.getDefaultBackedString("jira.clone.prefix");
            String cloneSummary = StringUtils.isBlank((CharSequence)clonePrefixProperties) ? summary : StringUtils.join((Object[])new Object[]{clonePrefixProperties, summary}, (String)" ");
            this.getFieldValuesHolder().put("summary", cloneSummary);
        }
    }

    public FieldScreenRenderLayoutItem getFieldScreenRenderLayoutItem(String fieldId) {
        return this.getFieldScreenRenderer().getFieldScreenRenderLayoutItem(this.fieldManager.getOrderableField(fieldId));
    }

    public Issue getIssueObject(GenericValue genericValue) {
        return this.issueFactory.getIssue(genericValue);
    }

    @Override
    protected void doValidation() {
        try {
            this.setOriginalIssue(this.getIssueObject(this.getIssue()));
        }
        catch (IssuePermissionException ipe) {
            return;
        }
        catch (IssueNotFoundException infe) {
            return;
        }
        SummarySystemField summaryField = (SummarySystemField)this.fieldManager.getOrderableField("summary");
        Map<String, Object> map = this.getFieldValuesHolder();
        ActionContext.getContext();
        summaryField.populateFromParams(map, ActionContext.getParameters());
        String summary = (String)this.getFieldValuesHolder().get(summaryField.getId());
        List<CustomField> customFields = this.getCustomFields(this.getOriginalIssue());
        this.cloneValidationResult = this.issueService.validateClone(this.getLoggedInUser(), this.getOriginalIssue(), summary, this.cloneAttachments, this.cloneSubTasks, this.cloneLinks, this.getCloneOptionSelections(customFields));
        if (!this.cloneValidationResult.isValid()) {
            this.setErrorMessages(this.cloneValidationResult.getErrorCollection().getErrorMessages());
            this.setErrors(this.cloneValidationResult.getErrorCollection().getErrors());
        }
    }

    private Map<CustomField, Optional<Boolean>> getCloneOptionSelections(List<CustomField> customFields) {
        Set requestParameters = this.getHttpRequest().getParameterMap().keySet();
        HashMap cloneOptionSelections = Maps.newHashMap();
        for (CustomField cf : customFields) {
            CloneOptionConfiguration cloneOptionConfiguration = cf.getCustomFieldType().getCloneOptionConfiguration(cf, this.getOriginalIssue());
            Optional<Object> cloneOptionSelection = cloneOptionConfiguration.shouldDisplayOption() ? Optional.of(requestParameters.contains(cf.getId())) : Optional.empty();
            cloneOptionSelections.put(cf, cloneOptionSelection);
        }
        return cloneOptionSelections;
    }

    @Override
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() {
        IssueService.AsynchronousTaskResult result = this.issueService.clone(this.getLoggedInUser(), this.cloneValidationResult);
        this.setReturnUrl(null);
        if (result.isValid()) {
            try {
                Long taskId = result.getTaskId();
                StopWatch watch = new StopWatch();
                watch.start();
                while (watch.getTime() < 500L) {
                    this.currentTaskDescriptor = this.taskManager.getTask(taskId);
                    if (this.currentTaskDescriptor.isFinished() && !this.currentTaskDescriptor.isCancelled()) {
                        return this.getTaskFinishedMessage();
                    }
                    Thread.sleep(50L);
                }
                this.currentTaskDescriptor = this.taskManager.getTask(taskId);
                TaskContext context = this.currentTaskDescriptor.getTaskContext();
                if (context instanceof CloneIssueTaskContext) {
                    this.originalIssue = this.getIssueManager().getIssueObject(((CloneIssueTaskContext)context).getOriginalIssueId());
                }
                return super.returnCompleteWithInlineRedirect(this.currentTaskDescriptor.getProgressURL());
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
                this.addErrorMessage(this.getText("admin.errors.exception") + " " + e);
                return "error";
            }
        }
        return "error";
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doProgress() throws ExecutionException, InterruptedException {
        if (this.taskId == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.id"));
            return "error";
        }
        this.currentTaskDescriptor = this.taskManager.getTask(this.taskId);
        if (this.currentTaskDescriptor == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.found"));
            return "error";
        }
        TaskContext context = this.currentTaskDescriptor.getTaskContext();
        if (!(context instanceof CloneIssueTaskContext)) {
            this.addErrorMessage(this.getText("common.tasks.wrong.task.context", CloneIssueTaskContext.class.getName(), context.getClass().getName()));
            return "error";
        }
        this.currentTask = this.taskBeanFactory.create(this.currentTaskDescriptor);
        if (this.currentTaskDescriptor.isFinished() && !this.currentTaskDescriptor.isCancelled()) {
            return this.getTaskFinishedMessage();
        }
        this.originalIssue = this.getIssueManager().getIssueObject(((CloneIssueTaskContext)context).getOriginalIssueId());
        return "progress";
    }

    private String getTaskFinishedMessage() {
        CloneIssueCommand.CloneIssueResult taskResult = this.currentTaskDescriptor.getResult();
        this.addErrorCollection(taskResult.getErrorCollection());
        if (taskResult.isSuccessful() && taskResult.getAttachmentCloneErrorCount() == 0L) {
            String clonedIssue = taskResult.getIssueKey();
            return this.inlineRedirectToIssueWithKey(clonedIssue);
        }
        if (taskResult.getAttachmentCloneErrorCount() > 0L) {
            TaskContext context = this.currentTaskDescriptor.getTaskContext();
            if (context instanceof CloneIssueTaskContext) {
                this.originalIssue = this.getIssueManager().getIssueObject(((CloneIssueTaskContext)context).getOriginalIssueId());
            }
            return ATTACHMENT_ERROR;
        }
        return "error";
    }

    @ActionViewData(value="attachment-error")
    public String getAttachmentCloneErrorTitle() {
        if (this.currentTaskDescriptor == null) {
            return "";
        }
        CloneIssueCommand.CloneIssueResult taskResult = this.currentTaskDescriptor.getResult();
        if (taskResult == null) {
            return "";
        }
        if (taskResult.getAttachmentCloneCount() == 1L) {
            return this.getI18nHelper().getText("cloneissue.clone.attachments.failed.single.title");
        }
        return this.getI18nHelper().getText("cloneissue.clone.attachments.failed.multiple.title", String.valueOf(taskResult.getAttachmentCloneErrorCount()), String.valueOf(taskResult.getAttachmentCloneCount()));
    }

    @ActionViewData(value="attachment-error")
    public String getAttachmentCloneErrorBody() {
        if (this.currentTaskDescriptor == null) {
            return "";
        }
        CloneIssueCommand.CloneIssueResult taskResult = this.currentTaskDescriptor.getResult();
        if (taskResult == null) {
            return "";
        }
        if (taskResult.getAttachmentCloneCount() == 1L) {
            return this.getI18nHelper().getText("cloneissue.clone.attachments.failed.single.body");
        }
        return this.getI18nHelper().getText("cloneissue.clone.attachments.failed.multiple.body");
    }

    @ActionViewData(value="attachment-error")
    public String getClonedIssuePath() {
        CloneIssueCommand.CloneIssueResult taskResult = this.currentTaskDescriptor.getResult();
        if (taskResult == null) {
            return null;
        }
        String issueKey = taskResult.getIssueKey();
        return BROWSE_ISSUE_PAGE_PREFIX + issueKey;
    }

    public boolean isDisplayCopyLink() {
        if (this.issueLinkManager.isLinkingEnabled()) {
            if (this.givenIssueHasAnyCopyableLink(this.getOriginalIssue())) {
                return true;
            }
            if (this.originalIssueHasSubTask()) {
                for (Issue subTask : this.getOriginalIssue().getSubTaskObjects()) {
                    if (!this.givenIssueHasAnyCopyableLink(subTask)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isDisplayCopyAttachments() {
        if (this.attachmentConfigManager.isAttachmentsEnabled()) {
            if (this.givenIssueHasAnyAttachment(this.originalIssue)) {
                return true;
            }
            if (this.subTaskManager.isSubTasksEnabled() && this.originalIssueHasSubTask()) {
                for (Issue subTask : this.originalIssue.getSubTaskObjects()) {
                    if (!this.givenIssueHasAnyAttachment(subTask)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isDisplayCopySubTasks() {
        return this.subTaskManager.isSubTasksEnabled() && this.originalIssueHasSubTask();
    }

    private boolean givenIssueHasAnyCopyableLink(Issue issue) {
        List inwardLinks = this.issueLinkManager.getInwardLinks(issue.getId());
        if (this.hasAnyCopyableLinkInGivenLinks(inwardLinks)) {
            return true;
        }
        List outwardLinks = this.issueLinkManager.getOutwardLinks(issue.getId());
        if (this.hasAnyCopyableLinkInGivenLinks(outwardLinks)) {
            return true;
        }
        List remoteLinks = this.remoteIssueLinkManager.getRemoteIssueLinksForIssue(issue);
        return !remoteLinks.isEmpty();
    }

    private boolean originalIssueHasSubTask() {
        return CollectionUtils.isNotEmpty((Collection)this.getOriginalIssue().getSubTaskObjects());
    }

    public boolean isCloneLinks() {
        return this.cloneLinks;
    }

    public void setCloneLinks(boolean cloneLinks) {
        this.cloneLinks = cloneLinks;
    }

    public boolean isCloneSubTasks() {
        return this.cloneSubTasks;
    }

    public void setCloneSubTasks(boolean cloneSubTasks) {
        this.cloneSubTasks = cloneSubTasks;
    }

    public boolean isCloneAttachments() {
        return this.cloneAttachments;
    }

    public void setCloneAttachments(boolean cloneAttachments) {
        this.cloneAttachments = cloneAttachments;
    }

    public Issue getOriginalIssue() {
        return this.originalIssue;
    }

    public void setOriginalIssue(Issue originalIssue) {
        this.originalIssue = originalIssue;
    }

    public IssueLinkType getCloneIssueLinkType() {
        if (this.cloneIssueLinkType == null) {
            Collection cloneIssueLinkTypes = this.issueLinkTypeManager.getIssueLinkTypesByName(this.getCloneLinkTypeName());
            if (StringUtils.isBlank((CharSequence)this.getCloneLinkTypeName())) {
                this.cloneIssueLinkType = null;
            } else if (CollectionUtils.isEmpty((Collection)cloneIssueLinkTypes)) {
                this.log.warn((Object)("The clone link type '" + this.getCloneLinkTypeName() + "' does not exist. A link to the original issue will not be created."));
                this.cloneIssueLinkType = null;
            } else {
                for (IssueLinkType issueLinkType : cloneIssueLinkTypes) {
                    if (!issueLinkType.getName().equals(this.getCloneLinkTypeName())) continue;
                    this.cloneIssueLinkType = issueLinkType;
                }
            }
        }
        return this.cloneIssueLinkType;
    }

    public boolean isDisplayCloneLinkWarning() {
        return StringUtils.isNotBlank((CharSequence)this.getCloneLinkTypeName()) && this.getCloneIssueLinkType() == null;
    }

    public boolean isCanModifyReporter() {
        return this.permissionManager.hasPermission(30, (Issue)this.getIssueObject(), this.getLoggedInUser());
    }

    public String getCloneLinkTypeName() {
        if (this.cloneIssueLinkTypeName == null) {
            this.cloneIssueLinkTypeName = this.applicationProperties.getDefaultBackedString("jira.clone.linktype.name");
        }
        return this.cloneIssueLinkTypeName;
    }

    @Override
    public Project getProjectObject() {
        return this.getProjectManager().getProjectObj(this.getIssue().getLong("project"));
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>();
        displayParams.put("theme", "aui");
        return displayParams;
    }

    private boolean hasAnyCopyableLinkInGivenLinks(Collection<IssueLink> givenLinks) {
        for (IssueLink checkingIssueLink : givenLinks) {
            if (!this.isCopyableLink(checkingIssueLink)) continue;
            return true;
        }
        return false;
    }

    private boolean isCopyableLink(IssueLink checkingLink) {
        return !checkingLink.isSystemLink() && (this.getCloneIssueLinkType() == null || this.givenLinkTypeIsNotSameAsCloneIssueLinkType(checkingLink));
    }

    private boolean givenLinkTypeIsNotSameAsCloneIssueLinkType(IssueLink checkingLink) {
        return !this.getCloneIssueLinkType().getId().equals(checkingLink.getIssueLinkType().getId());
    }

    private boolean givenIssueHasAnyAttachment(Issue givenIssue) {
        return CollectionUtils.isNotEmpty((Collection)this.attachmentManager.getAttachments(givenIssue));
    }

    @VisibleForTesting
    String inlineRedirectToIssueWithKey(String issueKey) {
        return super.returnCompleteWithInlineRedirect(BROWSE_ISSUE_PAGE_PREFIX + issueKey);
    }

    public TaskDescriptorBean<CloneIssueCommand.CloneIssueResult> getCurrentTask() {
        TaskDescriptor<CloneIssueCommand.CloneIssueResult> taskDescriptor;
        if (this.currentTask == null && (taskDescriptor = this.getCurrentTaskDescriptor()) != null) {
            this.currentTask = this.taskBeanFactory.create(taskDescriptor);
        }
        return this.currentTask;
    }

    private TaskDescriptor<CloneIssueCommand.CloneIssueResult> getCurrentTaskDescriptor() {
        if (this.currentTaskDescriptor == null) {
            this.currentTaskDescriptor = this.taskManager.getLiveTask(new AssignIssueSecuritySchemeTaskContext(this.getProject()));
        }
        return this.currentTaskDescriptor;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public static final class CustomFieldCloneOption {
        private final String id;
        private final String label;
        private final boolean selectedByDefault;

        public CustomFieldCloneOption(String id, String label, boolean selectedByDefault) {
            this.id = id;
            this.label = label;
            this.selectedByDefault = selectedByDefault;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isSelectedByDefault() {
            return this.selectedByDefault;
        }
    }
}

