/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.util.AttachmentConfigManager;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collection;
import java.util.Objects;
import org.ofbiz.core.entity.GenericValue;

public class ManageAttachments
extends AbstractCommentableIssue {
    private static final String ATTACH_FILE_ISSUE_OPERATION_KEY = "com.atlassian.jira.plugin.system.issueoperations:attach-file";
    private static final String ATTACH_SCREENSHOT_ISSUE_OPERATION_KEY = "com.atlassian.jira.plugin.system.issueoperations:attach-screenshot";
    private final AttachmentConfigManager attachmentConfigManager;
    private final AttachmentService attachmentService;
    private final PluginAccessor pluginAccessor;
    private Collection<GenericValue> affectedVersions;
    private Collection<GenericValue> components;
    private Collection<GenericValue> fixVersions;
    private Issue parentIssueObject;

    public ManageAttachments(SubTaskManager subTaskManager, AttachmentService attachmentService, PluginAccessor pluginAccessor, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, ProjectRoleManager projectRoleManager, CommentService commentService, UserUtil userUtil, AttachmentConfigManager attachmentConfigManager) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.attachmentConfigManager = Objects.requireNonNull(attachmentConfigManager);
        this.attachmentService = Objects.requireNonNull(attachmentService);
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
    }

    @Override
    protected void doValidation() {
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        try {
            Issue issue = this.getIssueObject();
        }
        catch (IssueNotFoundException ex) {
            this.addErrorMessage(this.getText("admin.errors.issues.issue.does.not.exist"));
            return "issuenotfound";
        }
        catch (IssuePermissionException ex) {
            this.addErrorMessage(this.getText("admin.errors.issues.no.browse.permission"));
            return "permissionviolation";
        }
        return super.doExecute();
    }

    public boolean isScreenshotAttachable() {
        return this.isIssueOperationShowable(ATTACH_SCREENSHOT_ISSUE_OPERATION_KEY) && this.attachmentService.canAttachScreenshots(this.getJiraServiceContext(), this.getIssueObject());
    }

    public boolean isAttachable() {
        return this.isIssueOperationShowable(ATTACH_FILE_ISSUE_OPERATION_KEY) && this.attachmentService.canCreateAttachments(this.getJiraServiceContext(), this.getIssueObject());
    }

    public boolean isHasDeleteAttachmentPermission(Long attachmentId) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(this.getLoggedInUser(), (ErrorCollection)new SimpleErrorCollection());
        return this.attachmentService.canDeleteAttachment((JiraServiceContext)context, attachmentId);
    }

    @Override
    public Issue getParentIssueObject() {
        Issue issue;
        if (this.isSubTask() && this.parentIssueObject == null && (issue = this.getIssueObject()).isSubTask() && issue.getParentObject() != null) {
            this.parentIssueObject = issue.getParentObject();
        }
        return this.parentIssueObject;
    }

    private boolean isIssueOperationShowable(String issueOperationKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(issueOperationKey);
        return moduleDescriptor != null;
    }

    @ActionViewData
    public boolean getZipSupport() {
        return this.attachmentConfigManager.isAttachmentsDownloadableAsZip();
    }

    public DateTimeFormatter getIso8601Formatter() {
        return this.getDateTimeFormatter().withStyle(DateTimeStyle.ISO_8601_DATE_TIME);
    }
}

