/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.security.IssueSecurityHelper;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.issue.MoveIssue;
import com.atlassian.jira.workflow.WorkflowManager;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import webwork.action.Action;
import webwork.action.ActionContext;

public class MoveIssueUpdateFields
extends MoveIssue
implements OperationContext {
    private MutableIssue targetIssue;
    private final IssueSecurityHelper issueSecurityHelper;
    private final HelpUrls helpUrls;

    public MoveIssueUpdateFields(SubTaskManager subTaskManager, ConstantsManager constantsManager, WorkflowManager workflowManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService, IssueSecurityHelper issueSecurityHelper, UserUtil userUtil, UserManager userManager, HelpUrls helpUrls) {
        super(subTaskManager, constantsManager, workflowManager, fieldManager, fieldLayoutManager, issueFactory, fieldScreenRendererFactory, commentService, userUtil, userManager);
        this.issueSecurityHelper = issueSecurityHelper;
        this.helpUrls = helpUrls;
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        MutableIssue originalIssue = this.getIssueObject(this.getIssue());
        MutableIssue targetIssue = this.getTargetIssueObject();
        if (!ActionContext.getSingleValueParameters().containsKey("reset") || !"true".equals(ActionContext.getSingleValueParameters().get("reset"))) {
            LinkedList<FieldLayoutItem> moveFieldLayoutItems = new LinkedList<FieldLayoutItem>();
            FieldLayout targetFieldLayout = this.getTargetFieldLayout();
            for (FieldLayoutItem fieldLayoutItem : targetFieldLayout.getVisibleLayoutItems(this.getTargetProjectObj(), EasyList.build((Object)this.getTargetIssueType()))) {
                OrderableField orderableField = fieldLayoutItem.getOrderableField();
                if ("issuetype".equals(orderableField.getId()) || !orderableField.needsMove((Collection)EasyList.build((Object)originalIssue), (Issue)targetIssue, fieldLayoutItem).getResult()) continue;
                if (orderableField.isShown((Issue)targetIssue)) {
                    orderableField.populateForMove(this.getMoveIssueBean().getFieldValuesHolder(), (Issue)originalIssue, (Issue)targetIssue);
                }
                moveFieldLayoutItems.add(fieldLayoutItem);
            }
            this.getMoveIssueBean().setMoveFieldLayoutItems(moveFieldLayoutItems);
        }
        this.validateAttachmentMove();
        if (this.isSubTask()) {
            this.getMoveIssueBean().setCurrentStep(2);
            this.getMoveIssueBean().addAvailablePreviousStep(3);
        } else {
            this.getMoveIssueBean().setCurrentStep(3);
            this.getMoveIssueBean().addAvailablePreviousStep(2);
        }
        return "input";
    }

    private void resetIssueKey(Issue originalIssue, MutableIssue targetIssue) {
        if (!Objects.equals(originalIssue.getProjectId(), targetIssue.getProjectId())) {
            targetIssue.setNumber(null);
        }
    }

    public Collection getMoveFieldLayoutItems() {
        return this.getMoveIssueBean().getMoveFieldLayoutItems();
    }

    protected MutableIssue getTargetIssueObject() {
        if (this.targetIssue == null) {
            this.targetIssue = this.getTargetIssueObjectWithSecurityLevel();
            if (this.issueSecurityHelper.securityLevelNeedsMove(this.getIssueObject(), (Issue)this.targetIssue)) {
                this.targetIssue.setSecurityLevel(null);
            }
        }
        return this.targetIssue;
    }

    protected MutableIssue getTargetIssueObjectWithSecurityLevel() {
        MutableIssue targetIssue = this.getIssueManager().getIssueObject(this.getId());
        targetIssue.setProjectObject(this.getTargetProjectObj());
        targetIssue.setIssueTypeObject(this.getTargetIssueTypeObject());
        return targetIssue;
    }

    protected FieldLayout getTargetFieldLayout() {
        return this.getFieldLayoutManager().getFieldLayout(this.getTargetProjectObj(), this.getTargetIssueType());
    }

    public String getFieldHtml(FieldLayoutItem fieldLayoutItem) {
        OrderableField orderableField = fieldLayoutItem.getOrderableField();
        MutableIssue targetIssue = this.issueFactory.cloneIssue((Issue)this.getTargetIssueObject());
        this.resetIssueKey((Issue)this.getIssueObject(this.getIssue()), targetIssue);
        orderableField.removeValueFromIssueObject(targetIssue);
        if (orderableField.isShown((Issue)targetIssue)) {
            return orderableField.getCreateHtml(fieldLayoutItem, (OperationContext)this.getMoveIssueBean(), (Action)this, (Issue)targetIssue);
        }
        return "";
    }

    public String getFieldName(Field field) {
        if (field instanceof CustomField) {
            return field.getName();
        }
        return this.getText(field.getNameKey());
    }

    @Override
    protected void doValidation() {
        if (this.getMoveIssueBean() != null) {
            try {
                if (!this.hasIssuePermission(ProjectPermissions.MOVE_ISSUES, this.getIssueObject())) {
                    this.addErrorMessage(this.getText("moveissue.no.permission"));
                }
                MutableIssue targetIssue = this.issueFactory.cloneIssue((Issue)this.getTargetIssueObject());
                for (Object o : this.getMoveFieldLayoutItems()) {
                    FieldLayoutItem fieldLayoutItem = (FieldLayoutItem)o;
                    OrderableField orderableField = fieldLayoutItem.getOrderableField();
                    if (orderableField.isShown((Issue)targetIssue)) {
                        this.populateFromParams(orderableField);
                        orderableField.removeValueFromIssueObject(targetIssue);
                        orderableField.validateParams((OperationContext)this.getMoveIssueBean(), (ErrorCollection)this, (I18nHelper)this, (Issue)targetIssue, (FieldScreenRenderLayoutItem)new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
                        continue;
                    }
                    this.popluateDefault(orderableField);
                    SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                    orderableField.validateParams((OperationContext)this.getMoveIssueBean(), (ErrorCollection)errorCollection, (I18nHelper)this, (Issue)targetIssue, (FieldScreenRenderLayoutItem)new FieldScreenRenderLayoutItemImpl(null, fieldLayoutItem));
                    if (errorCollection.getErrors() != null && !errorCollection.getErrors().isEmpty()) {
                        for (String s : errorCollection.getErrors().values()) {
                            this.addErrorMessage(this.getFieldName((Field)orderableField) + ": " + s);
                        }
                    }
                    this.addErrorMessages(errorCollection.getErrorMessages());
                }
            }
            catch (Exception e) {
                this.addErrorMessage(this.getText("admin.errors.issues.error.occurred.validating.field", e));
            }
        }
    }

    protected void popluateDefault(OrderableField orderableField) {
        orderableField.populateDefaults(this.getMoveIssueBean().getFieldValuesHolder(), (Issue)this.getTargetIssueObject());
    }

    protected void populateFromParams(OrderableField orderableField) {
        orderableField.populateFromParams(this.getMoveIssueBean().getFieldValuesHolder(), ActionContext.getParameters());
    }

    @Override
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        MutableIssue targetIssue = this.getTargetIssueObjectWithSecurityLevel();
        for (Object o1 : this.getMoveFieldLayoutItems()) {
            FieldLayoutItem fieldLayoutItem = (FieldLayoutItem)o1;
            OrderableField orderableField = fieldLayoutItem.getOrderableField();
            orderableField.updateIssue(fieldLayoutItem, targetIssue, this.getMoveIssueBean().getFieldValuesHolder());
        }
        LinkedList<OrderableField> removedFields = new LinkedList<OrderableField>();
        for (Object o : this.getTargetHiddenFields()) {
            Field field = (Field)o;
            if (field == null || !this.getFieldManager().isOrderableField(field)) continue;
            boolean doValueCheck = this.isShouldCheckFieldValue(this.getIssueObject(), field);
            OrderableField orderableField = (OrderableField)field;
            if (!doValueCheck || !orderableField.hasValue((Issue)targetIssue) || !orderableField.canRemoveValueFromIssueObject((Issue)targetIssue)) continue;
            orderableField.removeValueFromIssueObject(targetIssue);
            removedFields.add(orderableField);
        }
        this.getMoveIssueBean().setRemovedFields(removedFields);
        this.getMoveIssueBean().setUpdatedIssue(targetIssue);
        return "success";
    }

    protected boolean isShouldCheckFieldValue(Issue origIssue, Field field) {
        boolean doValueCheck = true;
        List issueTypeList = EasyList.build((Object)origIssue.getIssueTypeId());
        if (this.fieldManager.isCustomField(field) && !((CustomField)field).isInScope(origIssue.getProjectObject(), issueTypeList)) {
            doValueCheck = false;
        }
        return doValueCheck;
    }

    protected Collection getTargetHiddenFields() {
        return this.getTargetFieldLayout().getHiddenFields(this.getTargetProjectObj(), EasyList.build((Object)this.getTargetIssueType()));
    }

    public Map getCustomFieldValuesHolder() {
        return this.getMoveIssueBean().getFieldValuesHolder();
    }

    protected Collection<CustomField> getCurrentCustomFieldObjects(String issueTypeId) {
        return this.getCustomFieldManager().getCustomFieldObjects(this.getProjectObject().getId(), issueTypeId);
    }

    protected Collection<CustomField> getTargetCustomFieldObjects(String targetIssueTypeId) {
        return this.getCustomFieldManager().getCustomFieldObjects(this.getTargetPid(), targetIssueTypeId);
    }

    public Collection getTargetCustomFields() {
        return this.getTargetCustomFieldObjects(this.getTargetIssueType());
    }

    public String getCustomFieldContextHelpUrl() {
        return this.helpUrls.getUrl("customfields.configcustomfield.context").getUrl();
    }

    public boolean isUserAdmin() {
        return this.getAuthorizationSupport().hasGlobalPermission(GlobalPermissionKey.ADMINISTER);
    }
}

