/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.web.action.AjaxHeaders;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;

public class ViewSubtaskFragmentAction
extends AbstractIssueSelectAction {
    private static final String SUBTASK_PANEL_KEY = "com.atlassian.jira.jira-view-issue-plugin:view-subtasks";
    private final WebInterfaceManager webInterfaceManager;
    private Map<String, Object> webPanelParams;

    public ViewSubtaskFragmentAction(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    @VisibleForTesting
    protected Map<String, Object> getWebPanelContext() {
        if (this.webPanelParams == null) {
            Issue issue = this.getIssueObject();
            this.webPanelParams = new HashMap<String, Object>();
            this.webPanelParams.put("user", this.getLoggedInUser());
            this.webPanelParams.put("project", issue.getProjectObject());
            this.webPanelParams.put("issue", issue);
            this.webPanelParams.put("action", this);
            JiraHelper jiraHelper = new JiraHelper(this.request, issue.getProjectObject(), this.webPanelParams);
            this.webPanelParams.put("helper", jiraHelper);
            this.webPanelParams.put("isAsynchronousRequest", AjaxHeaders.isPjaxRequest((HttpServletRequest)this.request));
        }
        return this.webPanelParams;
    }

    public String getHtml() {
        final Map<String, Object> webPanelContext = this.getWebPanelContext();
        List webPanels = this.webInterfaceManager.getDisplayableWebPanelDescriptors("atl.jira.view.issue.left.context", webPanelContext);
        for (final WebPanelModuleDescriptor webPanel : webPanels) {
            Option moduleOutput = Option.option((Object)SafePluginPointAccess.call((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    if (ViewSubtaskFragmentAction.SUBTASK_PANEL_KEY.equals(webPanel.getCompleteKey())) {
                        WebPanel module = (WebPanel)webPanel.getModule();
                        return module != null ? module.getHtml(webPanelContext) : "";
                    }
                    return null;
                }
            }).getOrNull());
            if (!moduleOutput.isDefined()) continue;
            return (String)moduleOutput.get();
        }
        return "";
    }
}

