/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.index.ProjectReindexService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.ProjectCategoryFactory;
import com.atlassian.jira.event.project.ProjectEventManager;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.renderer.ProjectDescriptionRenderer;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.project.ViewProject;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ActionContext;

public class EditProject
extends ViewProject {
    private final ProjectService projectService;
    private final UserManager userManager;
    private final ProjectTypeManager projectTypeManager;
    private final ProjectDescriptionRenderer projectDescriptionRenderer;
    private final UserKeyService userKeyService;
    private final PageBuilderService pageBuilderService;
    private final ProjectReindexService projectReindexService;
    private final HelpUrls helpUrls;
    private final ProjectEventManager projectEventManager;
    private String originalKey;
    private boolean keyEdited;
    private Long projectCategoryId;

    public EditProject(ProjectService projectService, UserManager userManager, ProjectTypeManager projectTypeManager, UserKeyService userKeyService, PageBuilderService pageBuilderService, ProjectReindexService projectReindexService, HelpUrls helpUrls, ProjectEventManager projectEventManager) {
        this.projectService = projectService;
        this.userManager = userManager;
        this.projectTypeManager = projectTypeManager;
        this.userKeyService = userKeyService;
        this.pageBuilderService = pageBuilderService;
        this.projectReindexService = projectReindexService;
        this.helpUrls = helpUrls;
        this.projectEventManager = projectEventManager;
        this.projectDescriptionRenderer = (ProjectDescriptionRenderer)ComponentAccessor.getComponentOfType(ProjectDescriptionRenderer.class);
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        Project projectObject = this.getProjectObject();
        if (projectObject == null) {
            return this.handleProjectDoesNotExist();
        }
        if (!this.hasProjectAdminPermission() && !this.hasAdminPermission()) {
            return "securitybreach";
        }
        this.setName(projectObject.getName());
        this.setLead(this.userKeyService.getUsernameForKey(projectObject.getLeadUserKey()));
        this.setKeyEdited(false);
        String key = projectObject.getKey();
        this.setKey(key);
        this.setOriginalKey(key);
        this.setUrl(projectObject.getUrl());
        this.setDescription(projectObject.getDescription());
        this.setAssigneeType(projectObject.getAssigneeType());
        this.setAvatarId(projectObject.getAvatar().getId());
        this.setProjectTypeKey(projectObject.getProjectTypeKey().getKey());
        ProjectCategory initialProjectCategory = this.projectManager.getProjectCategoryForProject(projectObject);
        if (initialProjectCategory != null) {
            this.setProjectCategoryId(initialProjectCategory.getId());
        } else {
            this.setProjectCategoryId(ProjectCategoryFactory.NONE_PROJECT_CATEGORY_ID);
        }
        this.tagMauEventWithProject(projectObject);
        return "input";
    }

    @Override
    protected void doValidation() {
        if (this.getProjectObject() == null) {
            this.addErrorMessage(this.getText("admin.errors.project.no.project.with.id"));
            return;
        }
        ProjectService.UpdateProjectRequest update = this.getUpdateProjectRequest();
        ProjectService.UpdateProjectValidationResult validationResult = this.projectService.validateUpdateProject(this.getLoggedInUser(), update);
        if (!validationResult.isValid()) {
            this.mapErrorCollection(validationResult.getErrorCollection());
            if (this.getErrors().containsKey("projectTypeKey")) {
                this.setProjectTypeKey(this.getProject().getProjectTypeKey().getKey());
            }
        }
        if (validationResult.isKeyChanged() && !this.projectReindexService.isReindexPossible(this.getProjectObject())) {
            this.addError("key", this.getText("admin.errors.project.key.other.reindex"));
        }
        if (this.getErrorMessages().contains(this.getText("admin.projects.service.error.no.admin.permission.projectcategory"))) {
            if (this.getProjectObject().getProjectCategory() == null) {
                this.setProjectCategoryId(ProjectCategoryFactory.NONE_PROJECT_CATEGORY_ID);
            } else {
                this.setProjectCategoryId(this.getProjectObject().getProjectCategory().getId());
            }
        }
        super.doValidation();
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (!this.hasProjectAdminPermission() && !this.hasAdminPermission()) {
            return "securitybreach";
        }
        ProjectService.UpdateProjectRequest projectUpdate = this.getUpdateProjectRequest();
        ProjectCategory originalProjectCategory = this.getProjectObject().getProjectCategory();
        ProjectService.UpdateProjectValidationResult validationResult = this.projectService.validateUpdateProject(this.getLoggedInUser(), projectUpdate);
        this.projectService.updateProject(validationResult);
        if (this.isProjectCategoryChanging(originalProjectCategory)) {
            this.projectEventManager.dispatchProjectCategoryChanged(this.getRequestSourceType());
        }
        if (validationResult.isKeyChanged()) {
            String redirectURL = "/secure/project/IndexProject.jspa?confirmed=true&pid=" + this.getProjectObject().getId();
            this.getServletContext().getRequestDispatcher(redirectURL).forward((ServletRequest)this.getHttpRequest(), (ServletResponse)this.getHttpResponse());
            return "none";
        }
        String redirectURL = "/secure/project/EditProject!default.jspa?pid=" + this.getProjectObject().getId();
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect(redirectURL);
        }
        return this.getRedirect(redirectURL);
    }

    private Option<ProjectCategory> getProjectCategory() {
        if (null == this.getProjectCategoryId() || this.getProjectCategoryId().equals(ProjectCategoryFactory.NONE_PROJECT_CATEGORY_ID) || null == this.projectManager.getProjectCategoryObject(this.getProjectCategoryId())) {
            return Option.none();
        }
        return Option.some((Object)this.projectManager.getProjectCategoryObject(this.getProjectCategoryId()));
    }

    public String getAvatarUrl() {
        return ActionContext.getRequest().getContextPath() + "/secure/projectavatar?pid=" + this.getPid() + "&size=large&avatarId=" + this.getProjectObject().getAvatar().getId();
    }

    public String getProjectDescriptionEditHtml() {
        return this.projectDescriptionRenderer.getEditHtml(StringUtils.defaultString((String)this.getDescription()));
    }

    public ProjectDescriptionRenderer getProjectDescriptionRenderer() {
        return this.projectDescriptionRenderer;
    }

    private String handleProjectDoesNotExist() throws Exception {
        if (this.hasAdminPermission()) {
            this.setName(this.getText("common.sharing.exception.project.does.not.exist"));
            this.addErrorMessage(this.getText("admin.errors.project.no.project.with.id"));
            return super.doDefault();
        }
        return "securitybreach";
    }

    protected ProjectService.UpdateProjectValidationResult getUpdateProjectValidationResult() {
        Project projectObject = this.getProjectObject();
        if (this.isProjectKeyRenameAllowed() && this.isKeyEdited()) {
            return this.projectService.validateUpdateProject(this.getLoggedInUser(), this.getProjectObject(), this.getName(), this.getKey(), this.getDescription(), projectObject.getProjectLead(), this.getUrl(), projectObject.getAssigneeType(), this.getAvatarId());
        }
        return this.projectService.validateUpdateProject(this.getLoggedInUser(), this.getName(), projectObject.getKey(), this.getDescription(), projectObject.getProjectLead(), this.getUrl(), projectObject.getAssigneeType(), this.getAvatarId());
    }

    public Project getProject() {
        return this.projectManager.getProjectObj(this.getPid());
    }

    public boolean hasInvalidLead() {
        Project projectObject = this.getProjectObject();
        if (projectObject == null) {
            return false;
        }
        String leadUserName = projectObject.getLeadUserName();
        return this.userManager.getUserByName(leadUserName) == null;
    }

    public List<ProjectType> getProjectTypeOptions() {
        ArrayList accessibleProjectTypes = Lists.newArrayList((Iterable)this.projectTypeManager.getAllAccessibleProjectTypes());
        Option currentProjectType = this.projectTypeManager.getByKey(this.getProjectObject().getProjectTypeKey());
        if (currentProjectType.isDefined()) {
            ProjectType projectType = (ProjectType)currentProjectType.get();
            if (this.projectTypeManager.isProjectTypeInstalledButInaccessible(projectType.getKey())) {
                accessibleProjectTypes.add(projectType);
            }
        } else {
            ProjectType inaccessibleProjectType = this.projectTypeManager.getInaccessibleProjectType();
            ProjectType generatedProjectType = new ProjectType(this.getProjectObject().getProjectTypeKey(), inaccessibleProjectType.getDescriptionI18nKey(), inaccessibleProjectType.getIcon(), inaccessibleProjectType.getColor(), inaccessibleProjectType.getWeight());
            accessibleProjectTypes.add(generatedProjectType);
        }
        return accessibleProjectTypes;
    }

    public boolean isProjectTypeChangeAllowed() {
        return this.getGlobalPermissionManager().hasPermission(GlobalPermissionKey.ADMINISTER, this.getLoggedInUser());
    }

    public String getProjectTypeHelpUrl() {
        return this.helpUrls.getUrl("jira_applications_overview").getUrl();
    }

    private ProjectCategory createEmptyProjectCategory() {
        return new ProjectCategoryFactory.Builder().id(ProjectCategoryFactory.NONE_PROJECT_CATEGORY_ID).name("None").build();
    }

    public Collection<ProjectCategory> getProjectCategories() throws GenericEntityException {
        ArrayList projectCategoriesToDisplay = Lists.newArrayList((Object[])new ProjectCategory[]{this.createEmptyProjectCategory()});
        projectCategoriesToDisplay.addAll(this.projectManager.getAllProjectCategories());
        return projectCategoriesToDisplay;
    }

    public int getMaxNameLength() {
        return this.projectService.getMaximumNameLength();
    }

    public int getMaxKeyLength() {
        return this.projectService.getMaximumKeyLength();
    }

    public boolean isProjectKeyRenameAllowed() {
        return this.hasAdminPermission();
    }

    public void setOriginalKey(String originalKey) {
        this.originalKey = originalKey;
    }

    public String getOriginalKey() {
        return this.originalKey;
    }

    public void setKeyEdited(boolean keyEdited) {
        this.keyEdited = keyEdited;
    }

    public boolean isKeyEdited() {
        return this.keyEdited;
    }

    private ProjectService.UpdateProjectRequest getUpdateProjectRequest() {
        Project originalProject = this.getProjectObject();
        ProjectService.UpdateProjectRequest updateProjectRequest = new ProjectService.UpdateProjectRequest(originalProject);
        if (this.getKey() != null && !this.getKey().equals(originalProject.getKey())) {
            updateProjectRequest.key(this.getKey());
        }
        if (!this.getName().equals(originalProject.getName())) {
            updateProjectRequest.name(this.getName());
        }
        if (!this.getDescription().equals(originalProject.getDescription())) {
            updateProjectRequest.description(this.getDescription());
        }
        if (!this.getUrl().equals(originalProject.getUrl())) {
            updateProjectRequest.url(this.getUrl());
        }
        if (!this.getAvatarId().equals(originalProject.getAvatar().getId())) {
            updateProjectRequest.avatarId(this.getAvatarId());
        }
        if (this.getProjectTypeKey() != null && !this.getProjectTypeKey().equals(originalProject.getProjectTypeKey().getKey())) {
            updateProjectRequest.projectType(this.getProjectTypeKey());
        }
        if (this.getProjectCategoryId() != null && this.isProjectCategoryChanging(this.getProjectCategoryId(), originalProject.getProjectCategory())) {
            updateProjectRequest.projectCategoryId(this.getProjectCategoryId());
        }
        updateProjectRequest.requestSourceType(this.getRequestSourceType());
        return updateProjectRequest;
    }

    private boolean isProjectCategoryChanging(ProjectCategory originalProjectCategory) {
        if (!this.hasAdminPermission()) {
            return false;
        }
        ProjectCategory newProjectCategory = (ProjectCategory)this.getProjectCategory().getOrNull();
        if (originalProjectCategory == null && newProjectCategory == null) {
            return false;
        }
        if (originalProjectCategory == null && newProjectCategory != null || originalProjectCategory != null && newProjectCategory == null) {
            return true;
        }
        return ObjectUtils.compare((Comparable)originalProjectCategory.getId(), (Comparable)newProjectCategory.getId()) != 0;
    }

    @Override
    public String getKey() {
        if (!this.isKeyEdited()) {
            return this.getOriginalKey();
        }
        return super.getKey();
    }

    public Long getProjectCategoryId() {
        return this.projectCategoryId;
    }

    public void setProjectCategoryId(Long projectCategoryId) {
        this.projectCategoryId = projectCategoryId;
    }

    private boolean isProjectCategoryChanging(@Nonnull Long newProjectCategoryId, @Nullable ProjectCategory oldProjectCategory) {
        return this.hasProjectCategoryChangedFromDefault(newProjectCategoryId, oldProjectCategory) || this.hasProjectCategoryChanged(newProjectCategoryId, oldProjectCategory);
    }

    private boolean hasProjectCategoryChanged(@Nonnull Long newProjectCategoryId, @Nullable ProjectCategory oldProjectCategory) {
        return oldProjectCategory != null && !oldProjectCategory.getId().equals(newProjectCategoryId);
    }

    private boolean hasProjectCategoryChangedFromDefault(@Nonnull Long newProjectCategoryId, @Nullable ProjectCategory oldProjectCategory) {
        return oldProjectCategory == null && !newProjectCategoryId.equals(ProjectCategoryFactory.NONE_PROJECT_CATEGORY_ID);
    }
}

