/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.jira.action.component.ComponentUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.project.AbstractProjectAction;
import org.ofbiz.core.entity.GenericEntityException;

public class ViewProject
extends AbstractProjectAction {
    Long pid;
    Project project;

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        Project projectObject = this.getProjectObject();
        if (projectObject != null) {
            return this.getRedirect("/plugins/servlet/project-config/" + projectObject.getKey() + "/summary");
        }
        return this.getRedirect("/plugins/servlet/project-config/UNKNOWN/summary");
    }

    protected void doValidation() {
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        Project projectObject = this.getProjectObject();
        if (projectObject != null) {
            return this.getRedirect("/plugins/servlet/project-config/" + projectObject.getKey() + "/summary");
        }
        return this.getRedirect("/plugins/servlet/project-config/UNKNOWN/summary");
    }

    public boolean hasProjectAdminPermission() {
        return this.hasAdminPermission() || ComponentAccessor.getPermissionManager().hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, this.getProjectObject(), this.getLoggedInUser());
    }

    public boolean hasAdminPermission() {
        return ComponentAccessor.getPermissionManager().hasPermission(0, this.getLoggedInUser());
    }

    public boolean hasAssociateRolesPermission() throws Exception {
        return this.hasAdminPermission() || this.hasProjectAdminPermission();
    }

    public Project getProjectObject() {
        if (this.project == null) {
            if (this.getPid() != null) {
                this.project = this.getProjectManager().getProjectObj(this.getPid());
            } else if (this.getKey() != null) {
                this.project = this.getProjectManager().getProjectObjByKey(this.getKey());
                if (this.project != null) {
                    this.setPid(this.project.getId());
                }
            }
        }
        return this.project;
    }

    public boolean isDefaultAssigneeAssignable() throws GenericEntityException {
        Long assigneeType = this.getProjectObject().getAssigneeType();
        if (assigneeType != null && 2L == assigneeType) {
            return ComponentUtils.isProjectLeadAssignable(this.getProjectObject());
        }
        return true;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    @ActionViewData
    public Long getPid() {
        return this.pid;
    }
}

