/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcut;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.webfragment.DefaultWebFragmentContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ViewKeyboardShortcuts
extends JiraWebActionSupport {
    private final KeyboardShortcutManager keyboardShortcutManager;
    private final JiraAuthenticationContext authenticationContext;
    private boolean keyboardShortcutsEnabled;

    public ViewKeyboardShortcuts(KeyboardShortcutManager keyboardShortcutManager, JiraAuthenticationContext authenticationContext) {
        this.keyboardShortcutManager = keyboardShortcutManager;
        this.authenticationContext = authenticationContext;
    }

    public Map<KeyboardShortcutManager.Context, List<KeyboardShortcut>> getShortcutsForContext() {
        Map webContext = DefaultWebFragmentContext.get();
        List allShortcuts = this.keyboardShortcutManager.listActiveShortcutsUniquePerContext(webContext);
        LinkedHashMap<KeyboardShortcutManager.Context, List<KeyboardShortcut>> ret = new LinkedHashMap<KeyboardShortcutManager.Context, List<KeyboardShortcut>>();
        for (KeyboardShortcutManager.Context context : KeyboardShortcutManager.Context.values()) {
            ret.put(context, this.getShortcuts(context, allShortcuts));
        }
        return ret;
    }

    public String getContextName(KeyboardShortcutManager.Context context) {
        return this.getText("keyboard.shortcut.context." + context.toString());
    }

    public I18nHelper getI18nHelper() {
        return this.authenticationContext.getI18nHelper();
    }

    public String[] getFormSubmitKeys() {
        String modifierKeys = BrowserUtils.getModifierKey() + "+" + this.getText("common.forms.submit.accesskey");
        return modifierKeys.split("\\+");
    }

    public String[] getEditorSubmitKeys() {
        UserAgentUtil.OperatingSystem.OperatingSystemFamily OS = this.getUserAgentInfo().getOperatingSystem().getOperatingSystemFamily();
        return new String[]{UserAgentUtil.OperatingSystem.OperatingSystemFamily.MAC.equals((Object)OS) ? "&#8984;" : "Ctrl", "Enter"};
    }

    private UserAgentUtil.UserAgent getUserAgentInfo() {
        String userAgent = this.getHttpRequest().getHeader("User-Agent");
        UserAgentUtilImpl userAgentUtil = new UserAgentUtilImpl();
        return userAgentUtil.getUserAgentInfo(userAgent);
    }

    private List<KeyboardShortcut> getShortcuts(final KeyboardShortcutManager.Context context, List<KeyboardShortcut> shortcuts) {
        return new ArrayList<KeyboardShortcut>(CollectionUtil.filter(shortcuts, (Predicate)new Predicate<KeyboardShortcut>(){

            public boolean evaluate(KeyboardShortcut input) {
                return context.equals((Object)input.getContext());
            }
        }));
    }

    public boolean getKeyboardShortcutsEnabled() {
        return !this.getUserPreferences().getBoolean("user.keyboard.shortcuts.disabled");
    }

    public void setKeyboardShortcutsEnabled(boolean keyboardShortcutsEnabled) {
        this.keyboardShortcutsEnabled = keyboardShortcutsEnabled;
    }

    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.getLoggedInUser() != null) {
            this.getUserPreferences().setBoolean("user.keyboard.shortcuts.disabled", !this.keyboardShortcutsEnabled);
        }
        if (this.isInlineDialogMode()) {
            return this.returnComplete();
        }
        return super.doExecute();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.setKeyboardShortcutsEnabled(!this.getUserPreferences().getBoolean("user.keyboard.shortcuts.disabled"));
        return "input";
    }

    public Collection<TextOption> getKeyboardShortcutList() {
        String enabledText = this.getText("preferences.keyboard.shortcuts.enabled");
        String disabledText = this.getText("preferences.keyboard.shortcuts.disabled");
        return CollectionBuilder.list((Object[])new TextOption[]{new TextOption("true", enabledText), new TextOption("false", disabledText)});
    }

    public boolean isUserLoggedIn() {
        return this.getLoggedInUser() != null;
    }
}

