/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.bulkedit.BulkEditMultiSelectFieldOption;
import com.atlassian.jira.bulkedit.BulkEditMultiSelectFieldOptionAdd;
import com.atlassian.jira.bulkedit.BulkEditMultiSelectFieldOptionRemove;
import com.atlassian.jira.bulkedit.BulkEditMultiSelectFieldOptionRemoveAll;
import com.atlassian.jira.bulkedit.BulkEditMultiSelectFieldOptionReplace;
import com.atlassian.jira.bulkedit.BulkEditTextFieldOptionAddAfter;
import com.atlassian.jira.bulkedit.BulkEditTextFieldOptionAddBefore;
import com.atlassian.jira.bulkedit.BulkEditTextFieldOptionReplace;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.web.bean.BulkEditMultiSelectFieldBean;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class BulkEditMultiSelectFieldBeanImpl
implements BulkEditMultiSelectFieldBean {
    public static final String CHANGE_MODE_FIELD_PREFIX = "change";
    public static final BulkEditMultiSelectFieldOption MULTI_SELECT_FIELD_OPTION_ADD = new BulkEditMultiSelectFieldOptionAdd();
    public static final BulkEditMultiSelectFieldOption MULTI_SELECT_FIELD_OPTION_REMOVE = new BulkEditMultiSelectFieldOptionRemove();
    public static final BulkEditMultiSelectFieldOption MULTI_SELECT_FIELD_OPTION_REPLACE = new BulkEditMultiSelectFieldOptionReplace();
    public static final BulkEditMultiSelectFieldOption MULTI_SELECT_FIELD_OPTION_REMOVE_ALL = new BulkEditMultiSelectFieldOptionRemoveAll();
    public static final BulkEditMultiSelectFieldOption TEXT_FIELD_OPTION_ADD_AFTER = new BulkEditTextFieldOptionAddAfter();
    public static final BulkEditMultiSelectFieldOption TEXT_FIELD_OPTION_ADD_BEFORE = new BulkEditTextFieldOptionAddBefore();
    public static final BulkEditMultiSelectFieldOption TEXT_FIELD_OPTION_REPLACE = new BulkEditTextFieldOptionReplace();
    public static final Map<String, BulkEditMultiSelectFieldOption> CHANGE_MODE_LOOKUP = ImmutableMap.of((Object)"add", (Object)MULTI_SELECT_FIELD_OPTION_ADD, (Object)"remove", (Object)MULTI_SELECT_FIELD_OPTION_REMOVE, (Object)"replace", (Object)MULTI_SELECT_FIELD_OPTION_REPLACE, (Object)"removeall", (Object)MULTI_SELECT_FIELD_OPTION_REMOVE_ALL, (Object)"addafter", (Object)TEXT_FIELD_OPTION_ADD_AFTER, (Object)"addbefore", (Object)TEXT_FIELD_OPTION_ADD_BEFORE, (Object)"textreplace", (Object)TEXT_FIELD_OPTION_REPLACE);
    public static final Set<BulkEditMultiSelectFieldOption> MULTI_SELECT_CHANGE_MODES = ImmutableSet.of((Object)MULTI_SELECT_FIELD_OPTION_ADD, (Object)MULTI_SELECT_FIELD_OPTION_REMOVE, (Object)MULTI_SELECT_FIELD_OPTION_REPLACE, (Object)MULTI_SELECT_FIELD_OPTION_REMOVE_ALL);
    public static final Set<BulkEditMultiSelectFieldOption> TEXT_CHANGE_MODES = ImmutableSet.of((Object)TEXT_FIELD_OPTION_ADD_AFTER, (Object)TEXT_FIELD_OPTION_ADD_BEFORE, (Object)TEXT_FIELD_OPTION_REPLACE);
    public static final Map<String, Set<BulkEditMultiSelectFieldOption>> SYSTEM_FIELD_CHANGE_MODES = ImmutableMap.of((Object)"versions", MULTI_SELECT_CHANGE_MODES, (Object)"components", MULTI_SELECT_CHANGE_MODES, (Object)"description", TEXT_CHANGE_MODES, (Object)"fixVersions", MULTI_SELECT_CHANGE_MODES, (Object)"labels", MULTI_SELECT_CHANGE_MODES);
    public static final Map<String, BulkEditMultiSelectFieldOption> DEFAULT_CHANGE_MODES = ImmutableMap.of((Object)"versions", (Object)MULTI_SELECT_FIELD_OPTION_ADD, (Object)"components", (Object)MULTI_SELECT_FIELD_OPTION_ADD, (Object)"description", (Object)TEXT_FIELD_OPTION_ADD_AFTER, (Object)"fixVersions", (Object)MULTI_SELECT_FIELD_OPTION_ADD, (Object)"labels", (Object)MULTI_SELECT_FIELD_OPTION_ADD);
    private final Map<String, BulkEditMultiSelectFieldOption> changeModeOptions = Maps.newHashMap();

    public boolean isChangeModeSelectionAllowed(OrderableField field) {
        return SYSTEM_FIELD_CHANGE_MODES.containsKey(field.getId());
    }

    public boolean isChangeModeSelectionAllowed(OrderableField<?> field, String changeModeId) {
        return SYSTEM_FIELD_CHANGE_MODES.containsKey(field.getId()) && SYSTEM_FIELD_CHANGE_MODES.get(field.getId()).contains(CHANGE_MODE_LOOKUP.get(changeModeId));
    }

    public String getChangeModeFieldName(OrderableField field) {
        return CHANGE_MODE_FIELD_PREFIX + field.getId();
    }

    public void setChangeModeForField(OrderableField field, BulkEditMultiSelectFieldOption changeMode) throws IllegalArgumentException {
        if (!this.isChangeModeSelectionAllowed(field, changeMode.getId())) {
            throw new IllegalArgumentException("Field not supported for BulkEditMultiSelect change: " + field.getId());
        }
        this.changeModeOptions.put(field.getId(), changeMode);
    }

    public Option<BulkEditMultiSelectFieldOption> getChangeModeForField(OrderableField field) {
        if (this.isChangeModeSelectionAllowed(field)) {
            return Option.some((Object)this.changeModeOptions.getOrDefault(field.getId(), this.getDefaultChangeModeOptionForField(field)));
        }
        return Option.none();
    }

    public void setChangeModeFromParams(OrderableField field, Map<String, String[]> params) throws IllegalArgumentException {
        if (!this.isChangeModeSelectionAllowed(field)) {
            throw new IllegalArgumentException(String.format("Field \"%s\" does not support setting a change mode.", field.getId()));
        }
        String fieldName = this.getChangeModeFieldName(field);
        String[] selectedOptions = params.get(fieldName);
        String selectedOption = null;
        if (selectedOptions != null) {
            for (String value : selectedOptions) {
                if (this.getChangeModeOptionById(value) == null || !this.isChangeModeSelectionAllowed(field, value)) continue;
                selectedOption = value;
            }
        }
        if (selectedOption == null) {
            selectedOption = this.getDefaultChangeModeOptionForField(field).getId();
        }
        this.changeModeOptions.put(field.getId(), this.getChangeModeOptionById(selectedOption));
    }

    public Collection<BulkEditMultiSelectFieldOption> getChangeModeOptions() {
        return MULTI_SELECT_CHANGE_MODES;
    }

    public Collection<BulkEditMultiSelectFieldOption> getChangeModeOptionsForField(OrderableField<?> field) {
        return SYSTEM_FIELD_CHANGE_MODES.get(field.getId());
    }

    public BulkEditMultiSelectFieldOption getDefaultChangeModeOption() {
        return MULTI_SELECT_FIELD_OPTION_ADD;
    }

    public BulkEditMultiSelectFieldOption getDefaultChangeModeOptionForField(OrderableField<?> field) {
        return DEFAULT_CHANGE_MODES.get(field.getId());
    }

    public BulkEditMultiSelectFieldOption getChangeModeOptionById(String id) {
        return CHANGE_MODE_LOOKUP.get(id);
    }

    public String getMultiSelectFieldActionDescription(OrderableField field) {
        Option<BulkEditMultiSelectFieldOption> option = this.getChangeModeForField(field);
        return option.isDefined() ? ((BulkEditMultiSelectFieldOption)option.get()).getDescriptionI18nKey() : "";
    }
}

