/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.component.AbstractWebComponent;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.IssueTableWriter;
import com.atlassian.jira.web.component.Pager;
import com.atlassian.jira.web.component.subtask.ColumnLayoutItemFactory;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IssueTableWebComponent
extends AbstractWebComponent {
    private final JiraAuthenticationContext authenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponentOfType(JiraAuthenticationContext.class);
    private final ColumnLayoutItemFactory columnLayoutItemFactory = (ColumnLayoutItemFactory)ComponentAccessor.getComponentOfType(ColumnLayoutItemFactory.class);
    private static final String ISSUETABLE_HEADER = "templates/jira/issue/table/issuetable-header.vm";
    private static final String ISSUETABLE_FOOTER = "templates/jira/issue/table/issuetable-footer.vm";
    private static final String ISSUETABLE_SINGLE_ISSUE = "templates/jira/issue/table/issuetable-issue.vm";
    private static final String CARROT_HIDDEN = "class=\"hide-carrot\"";

    public IssueTableWebComponent() {
        super((VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class), (ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class));
    }

    @Deprecated
    public String getHtml(IssueTableLayoutBean layout, List<Issue> issues, Pager pager) {
        return this.getHtml(layout, issues, pager, null);
    }

    @Deprecated
    public String getHtml(IssueTableLayoutBean layout, List<Issue> issues, Pager pager, Long selectedIssueId) {
        StringWriter writer = new StringWriter();
        this.asHtml(writer, layout, issues, pager, selectedIssueId);
        return writer.toString();
    }

    public void asHtml(Writer writer, IssueTableLayoutBean layout, List<Issue> issues, Pager pager, Long selectedIssueId) {
        try (Ticker ignored = Timers.start((String)"IssueTableHtml");){
            try {
                ColumnLayoutItem actionColumn = layout.isShowActionColumn() && this.authenticationContext.getUser() != null ? this.columnLayoutItemFactory.getActionsAndOperationsColumn() : null;
                IssueTableWriter issueTableWriter = this.getHtmlIssueWriter(writer, layout, pager, actionColumn, selectedIssueId);
                for (Issue issue : issues) {
                    issueTableWriter.write(issue);
                }
                issueTableWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public IssueTableWriter getHtmlIssueWriter(Writer writer, IssueTableLayoutBean layout, Pager pager, ColumnLayoutItem actionColumn) {
        return this.getHtmlIssueWriter(writer, layout, pager, actionColumn, null);
    }

    @Deprecated
    public IssueTableWriter getHtmlIssueWriter(final Writer writer, IssueTableLayoutBean layout, Pager pager, ColumnLayoutItem actionColumn, Long selectedIssueId) {
        String carrothiddenString = "";
        boolean keyboadShortcutsEnabled = true;
        if (this.authenticationContext.getUser() != null) {
            Preferences userPrefs = ComponentAccessor.getUserPreferencesManager().getPreferences(this.authenticationContext.getUser());
            boolean bl = keyboadShortcutsEnabled = !userPrefs.getBoolean("user.keyboard.shortcuts.disabled");
        }
        if (!keyboadShortcutsEnabled) {
            carrothiddenString = CARROT_HIDDEN;
        }
        final Map<String, Object> params = this.getDefaultParams(MapBuilder.newBuilder().add((Object)"layout", (Object)layout).add((Object)"i18n", (Object)this.authenticationContext.getI18nHelper()).add((Object)"pager", (Object)pager).add((Object)"columnTotals", null).add((Object)"actionColumn", (Object)actionColumn).add((Object)"selectedIssueId", (Object)selectedIssueId).add((Object)"carrothidden", (Object)carrothiddenString).toMap());
        return new IssueTableWriter(){
            int issueCount = 0;

            @Override
            public void write(Issue issue) throws IOException {
                ++this.issueCount;
                if (this.issueCount == 1) {
                    IssueTableWebComponent.this.asHtml(writer, IssueTableWebComponent.ISSUETABLE_HEADER, params);
                }
                HashMap<String, Object> issueParams = new HashMap<String, Object>();
                issueParams.put("issue", issue);
                issueParams.put("issueCount", this.issueCount);
                IssueTableWebComponent.this.asHtml(writer, IssueTableWebComponent.ISSUETABLE_SINGLE_ISSUE, CompositeMap.of(issueParams, (Map)params));
            }

            @Override
            public void close() throws IOException {
                if (this.issueCount > 0) {
                    IssueTableWebComponent.this.asHtml(writer, IssueTableWebComponent.ISSUETABLE_FOOTER, params);
                }
            }
        };
    }

    private Map<String, Object> getDefaultParams(Map<String, Object> startingParams) {
        return JiraVelocityUtils.getDefaultVelocityParams(startingParams, this.authenticationContext);
    }
}

