/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.InstanceFeatureManager;
import com.atlassian.jira.event.mau.LastSentKey;
import com.atlassian.jira.event.mau.MauEventService;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MauEventFilter
extends AbstractHttpFilter {
    public static final String MAU_FEATURE_LOGGING = "jira.event.mau.logging";
    private static final String MAU_IGNORE_HEADER = "x-atlassian-mau-ignore";
    private static final Logger LOGGER = LoggerFactory.getLogger(MauEventFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean ignoreMauEvent;
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable throwable) {
            boolean ignoreMauEvent2;
            boolean bl = ignoreMauEvent2 = request.getHeader(MAU_IGNORE_HEADER) != null;
            if (!ignoreMauEvent2) {
                this.getMauEventService().ifPresent(service -> {
                    service.triggerEvent();
                    boolean shouldLogMau = this.getFeatureManager().map(featureManager -> featureManager.isInstanceFeatureEnabled(MAU_FEATURE_LOGGING)).orElse(false);
                    LastSentKey key = service.getKeyWithCurrentApplication();
                    if (shouldLogMau && key != null && LOGGER.isInfoEnabled()) {
                        LOGGER.info("MAU registered to '{}' by '{}'", (Object)key.getApplicationKey().getKey(), (Object)key.getUserId());
                    }
                });
            }
            throw throwable;
        }
        boolean bl = ignoreMauEvent = request.getHeader(MAU_IGNORE_HEADER) != null;
        if (!ignoreMauEvent) {
            this.getMauEventService().ifPresent(service -> {
                service.triggerEvent();
                boolean shouldLogMau = this.getFeatureManager().map(featureManager -> featureManager.isInstanceFeatureEnabled(MAU_FEATURE_LOGGING)).orElse(false);
                LastSentKey key = service.getKeyWithCurrentApplication();
                if (shouldLogMau && key != null && LOGGER.isInfoEnabled()) {
                    LOGGER.info("MAU registered to '{}' by '{}'", (Object)key.getApplicationKey().getKey(), (Object)key.getUserId());
                }
            });
        }
    }

    @VisibleForTesting
    Optional<MauEventService> getMauEventService() {
        return ComponentAccessor.getComponentSafely(MauEventService.class);
    }

    @VisibleForTesting
    Optional<InstanceFeatureManager> getFeatureManager() {
        return ComponentAccessor.getComponentSafely(InstanceFeatureManager.class);
    }
}

