/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.johnson;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.startup.mode.StartupModeReference;
import com.atlassian.jira.util.johnson.JohnsonEventPredicates;
import com.atlassian.jira.web.startup.StartupPageSupport;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.EventPredicates;
import com.atlassian.johnson.setup.SetupConfig;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
class JohnsonInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(JohnsonInterceptor.class);
    private final SetupConfig setup;
    private final HttpServletRequest request;
    private final String servletPath;
    private final Predicate<String> shouldIgnoreUri;
    private final Startup startup;
    private final JohnsonEventContainer container;
    private final Supplier<Optional<StartupModeReference>> startupModeReferenceSupplier;
    private final boolean ignoreDismissibles;
    private Boolean filtered;

    @Nonnull
    static JohnsonInterceptor getInstance(JohnsonEventContainer container, String servletPath, SetupConfig setup, HttpServletRequest request, Predicate<String> shouldIgnoreUri) {
        return new JohnsonInterceptor(container, servletPath, setup, request, shouldIgnoreUri, new Startup(){

            @Override
            public boolean isLaunched() {
                return StartupPageSupport.isLaunched();
            }

            @Override
            public boolean isStartupPage(HttpServletRequest request) {
                return StartupPageSupport.isStartupPage(request);
            }
        }, ComponentAccessor.safeSupplierOf(StartupModeReference.class), JiraSystemProperties.getInstance().getBoolean("jira.startup.warnings.disable"));
    }

    @VisibleForTesting
    JohnsonInterceptor(JohnsonEventContainer container, String servletPath, SetupConfig setup, HttpServletRequest request, Predicate<String> shouldIgnoreUri, Startup startup, Supplier<Optional<StartupModeReference>> startupModeReferenceSupplier, boolean ignoreDismissibles) {
        this.container = Objects.requireNonNull(container);
        this.setup = Objects.requireNonNull(setup);
        this.request = Objects.requireNonNull(request);
        this.servletPath = Objects.requireNonNull(servletPath);
        this.shouldIgnoreUri = Objects.requireNonNull(shouldIgnoreUri);
        this.startup = Objects.requireNonNull(startup);
        this.startupModeReferenceSupplier = startupModeReferenceSupplier;
        this.ignoreDismissibles = Objects.requireNonNull(ignoreDismissibles);
    }

    @Nonnull
    Optional<Reason> intercept() throws IOException {
        if (!this.shouldBeJohnsonFilteredPage()) {
            LOG.debug("This page should be ignored as specified in johnson-config.xml. Current servletPath = '{}'", (Object)this.servletPath);
            return Optional.empty();
        }
        return this.interceptErrors().orElse(this::interceptStartup).orElse(this::interceptSetup).toOptional();
    }

    private boolean shouldBeJohnsonFilteredPage() {
        if (this.filtered == null) {
            this.filtered = !this.shouldIgnoreUri.test(this.servletPath);
        }
        return this.filtered;
    }

    @Nonnull
    private Option<Reason> interceptErrors() {
        if (this.johnsonHasDisplayableEvents()) {
            return Option.some((Object)((Object)Reason.JOHNSON_EVENT));
        }
        return Option.none();
    }

    @Nonnull
    private Option<Reason> interceptStartup() {
        if (this.startup.isLaunched()) {
            return Option.none();
        }
        if (this.startup.isStartupPage(this.request)) {
            throw new IllegalStateException("StartupProgressFilter should have terminated the filter chain!");
        }
        return Option.some((Object)((Object)Reason.STARTUP_PAGE));
    }

    @Nonnull
    private Option<Reason> interceptSetup() {
        if (this.setup.isSetup() || this.setup.isSetupPage(this.servletPath)) {
            return Option.none();
        }
        return Option.some((Object)((Object)Reason.NOT_SETUP));
    }

    private boolean johnsonHasDisplayableEvents() {
        if (this.container.hasEvent(JohnsonEventPredicates.blocksStartup())) {
            return true;
        }
        return this.isUpgrading() && !this.ignoreDismissibles && this.container.hasEvent(EventPredicates.attributeEquals((String)"dismissible", (Object)true));
    }

    private boolean isUpgrading() {
        return this.startupModeReferenceSupplier.get().map(StartupModeReference::isUpgrading).orElse(false);
    }

    public static enum Reason {
        JOHNSON_EVENT,
        STARTUP_PAGE,
        NOT_SETUP;

    }

    static interface Startup {
        public boolean isLaunched();

        public boolean isStartupPage(HttpServletRequest var1);
    }
}

