/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.security;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.web.filters.steps.FilterCallContext;
import com.atlassian.jira.web.filters.steps.FilterCallContextImpl;
import com.atlassian.jira.web.filters.steps.FilterStep;
import com.atlassian.jira.web.filters.steps.security.HttpSecurityConfig;
import com.atlassian.jira.web.filters.steps.security.csp.DynamicContentSecurityPolicyResponseWrapperFactory;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSecurityStep
implements FilterStep {
    private static final Logger log = LoggerFactory.getLogger(HttpSecurityStep.class);
    private static final String ASSETS_SERVLET_PATH = "/s";
    private static final String STRICT_ORIGIN_WHEN_CROSS_ORIGIN = "strict-origin-when-cross-origin";
    private static final String X_XSS_PROTECTION_VALUE = "1; mode=block";
    private static final String X_CONTENT_TYPE_OPTIONS_VALUE = "nosniff";
    private static final String X_FRAME_OPTIONS_VALUE = "SAMEORIGIN";
    private static final String CONTENT_SECURITY_POLICY_VALUE = "frame-ancestors 'self'";
    private final HttpSecurityConfig httpSecurityConfig = this.getHttpSecurityConfig().orElse(null);

    public HttpSecurityStep() {
        if (this.httpSecurityConfig == null) {
            log.debug("All resources have clickjacking protection right now. That's OK for Jira in setup and start-up mode.");
        }
    }

    @Override
    public FilterCallContext beforeDoFilter(FilterCallContext context) {
        HttpServletRequest request = context.getHttpServletRequest();
        HttpServletResponse response = context.getHttpServletResponse();
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        log.debug("setting XSS and nosniff protection for servlet path [{}] for path [{}]", (Object)servletPath, (Object)pathInfo);
        response.setHeader("Referrer-Policy", STRICT_ORIGIN_WHEN_CROSS_ORIGIN);
        response.setHeader("X-XSS-Protection", X_XSS_PROTECTION_VALUE);
        response.setHeader("X-Content-Type-Options", X_CONTENT_TYPE_OPTIONS_VALUE);
        boolean clickjackingProtection = true;
        if (!servletPath.equals(ASSETS_SERVLET_PATH) && this.httpSecurityConfig != null) {
            boolean bl = clickjackingProtection = !this.httpSecurityConfig.isClickjackingProtectionDisabled() && !this.httpSecurityConfig.isExcluded(HttpSecurityStep.combinePaths(servletPath, pathInfo));
        }
        if (clickjackingProtection) {
            log.debug("setting clickjacking protection for servlet path [{}] for path [{}]", (Object)servletPath, (Object)pathInfo);
            response.setHeader("X-Frame-Options", X_FRAME_OPTIONS_VALUE);
            response.setHeader("Content-Security-Policy", CONTENT_SECURITY_POLICY_VALUE);
        }
        this.setStrictTransportSecurityHeader(response);
        return new FilterCallContextImpl(context.getHttpServletRequest(), (HttpServletResponse)DynamicContentSecurityPolicyResponseWrapperFactory.getWrapper(context.getHttpServletResponse(), context.getHttpServletRequest()), context.getFilterChain(), context.getFilterConfig());
    }

    private void setStrictTransportSecurityHeader(HttpServletResponse response) {
        if (this.httpSecurityConfig == null || !this.httpSecurityConfig.isStrictTransportSecurityDisabled()) {
            Long maxAge;
            Long l = maxAge = this.httpSecurityConfig == null ? null : this.httpSecurityConfig.getStrictTransportSecurityMaxAge();
            if (maxAge == null) {
                maxAge = Duration.of(365L, ChronoUnit.DAYS).getSeconds();
            }
            String headerValue = "max-age=" + maxAge + this.getStrictTransportSecurityAdditionalParams();
            response.setHeader("Strict-Transport-Security", headerValue);
        }
    }

    @Nonnull
    private String getStrictTransportSecurityAdditionalParams() {
        String headerAdditionalParams = "";
        if (this.httpSecurityConfig != null) {
            if (this.httpSecurityConfig.isStrictTransportSecurityIncludeSubDomainsEnabled() || this.httpSecurityConfig.isStrictTransportSecurityPreloadEnabled()) {
                headerAdditionalParams = headerAdditionalParams + "; includeSubDomains";
            }
            if (this.httpSecurityConfig.isStrictTransportSecurityPreloadEnabled()) {
                headerAdditionalParams = headerAdditionalParams + "; preload";
            }
            if (this.httpSecurityConfig.getStrictTransportSecurityAdditionalParams() != null) {
                headerAdditionalParams = headerAdditionalParams + "; " + this.httpSecurityConfig.getStrictTransportSecurityAdditionalParams();
            }
        }
        return headerAdditionalParams;
    }

    @Override
    public FilterCallContext finallyAfterDoFilter(FilterCallContext context) {
        return context;
    }

    private Optional<HttpSecurityConfig> getHttpSecurityConfig() {
        return ComponentAccessor.getComponentSafely(HttpSecurityConfig.class);
    }

    private static String combinePaths(@NotNull String path, @Nullable String optionalPath) {
        StringBuilder sb = new StringBuilder(path);
        if (optionalPath != null) {
            sb.append(optionalPath);
        }
        return sb.toString();
    }
}

