/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet.viewfile;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.mail.analytics.NotificationEmailAttachmentLoadedAnalyticsEvent;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.NoAttachmentDataException;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtGenerateSecretException;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtParseException;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtSecurityException;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtToken;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtTokenService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.web.exception.WebExceptionChecker;
import com.atlassian.jira.web.servlet.BadRequestException;
import com.atlassian.jira.web.servlet.InvalidAttachmentPathException;
import com.atlassian.jira.web.servlet.RangeNotSatisfiableException;
import com.atlassian.jira.web.servlet.viewfile.RangeRequest;
import com.atlassian.jira.web.servlet.viewfile.RangeResponse;
import com.atlassian.seraph.util.RedirectUtils;
import io.atlassian.fugue.Unit;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractViewFileServlet
extends HttpServlet {
    @VisibleForTesting
    public static String IMAGE_DISPLAYING_CANNOT_DISPLAY_IMAGE_PATH = "/images/mail/attachment/email-cannot-display-image-attachment.png";
    public static final String IMAGE_ATTACHMENT_JWT_TOKEN_QUERY_PARAM_NAME = "imgAttachmentToken";
    private static final Logger log = LoggerFactory.getLogger(AbstractViewFileServlet.class);
    private static final int BUFFER_SIZE = 4096;
    private static final ApplicationUser ANONYMOUS_USER = null;
    private final Supplier<ImageAttachmentJwtTokenService> imageAttachmentJwtTokenServiceSupplier;
    private final Supplier<JiraAuthenticationContext> jiraAuthenticationContextSupplier;
    private final Supplier<AttachmentManager> attachmentManagerSupplier;
    private final Supplier<UserManager> userManagerSupplier;
    private final Supplier<PermissionManager> permissionManagerSupplier;
    private final Supplier<ApplicationProperties> applicationPropertiesSupplier;
    private final Supplier<EventPublisher> eventPublisherSupplier;
    private final LongSupplier currentTimeMillis = System::currentTimeMillis;

    public AbstractViewFileServlet() {
        this.imageAttachmentJwtTokenServiceSupplier = () -> (ImageAttachmentJwtTokenService)ComponentAccessor.getComponent(ImageAttachmentJwtTokenService.class);
        this.jiraAuthenticationContextSupplier = ComponentAccessor::getJiraAuthenticationContext;
        this.attachmentManagerSupplier = ComponentAccessor::getAttachmentManager;
        this.userManagerSupplier = ComponentAccessor::getUserManager;
        this.permissionManagerSupplier = ComponentAccessor::getPermissionManager;
        this.applicationPropertiesSupplier = ComponentAccessor::getApplicationProperties;
        this.eventPublisherSupplier = () -> (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
    }

    protected AttachmentManager getAttachmentManager() {
        return this.attachmentManagerSupplier.get();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String attachmentQuery;
            try {
                attachmentQuery = this.attachmentQuery(request);
            }
            catch (InvalidAttachmentPathException e) {
                response.sendError(400, "Invalid attachment path");
                return;
            }
            catch (AttachmentNotFoundException nfe) {
                this.send404(response);
                return;
            }
            this.streamFileData(request, response, attachmentQuery);
        }
        catch (Exception e) {
            if (WebExceptionChecker.canBeSafelyIgnored(e)) {
                return;
            }
            log.error("Error serving file for path " + request.getPathInfo() + ": " + e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void send404(HttpServletResponse response) throws IOException {
        response.sendError(404, String.format("Attachment was not found", new Object[0]));
    }

    private void redirectToSecurityBreachOrLoginPage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isUserLoggedIn()) {
            RequestDispatcher rd = request.getRequestDispatcher("/secure/views/securitybreach.jsp");
            JiraHttpUtils.setNoCacheHeaders((HttpServletResponse)response);
            rd.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)request));
        }
    }

    private void streamFileData(final HttpServletRequest request, final HttpServletResponse response, String attachmentPath) throws IOException, ServletException {
        block8: {
            Optional<RangeResponse> rangeResponse;
            try {
                rangeResponse = this.createRangeResponse(request, attachmentPath);
            }
            catch (BadRequestException ex) {
                this.send400(response, ex);
                return;
            }
            catch (RangeNotSatisfiableException ex) {
                this.send416(response, ex);
                return;
            }
            try {
                InputStreamConsumer<Unit> inputStreamConsumer = new InputStreamConsumer<Unit>(){

                    public Unit withInputStreamAndLength(@Nonnull InputStream inputStream, @Nullable Long length) throws IOException {
                        AbstractViewFileServlet.this.setResponseContentHeaders(request, rangeResponse, response, Optional.ofNullable(length));
                        try (ServletOutputStream out = response.getOutputStream();){
                            AbstractViewFileServlet.this.copyStream(inputStream, (OutputStream)out, rangeResponse);
                        }
                        return Unit.Unit();
                    }

                    public Unit withInputStream(InputStream inputStream) throws IOException {
                        return this.withInputStreamAndLength(inputStream, null);
                    }
                };
                this.getInputStream(request, attachmentPath, inputStreamConsumer);
            }
            catch (AttachmentNotFoundException | NoAttachmentDataException | FileNotFoundException ex) {
                this.handleNoAttachmentResponse(request, response, (Exception)ex);
            }
            catch (JwtAttachmentPermissionException e) {
                this.redirectToImageWithDenialReason(response);
            }
            catch (PermissionException e) {
                this.redirectToSecurityBreachOrLoginPage(request, response);
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug("Error serving content to client", (Throwable)e);
            }
        }
    }

    private void handleNoAttachmentResponse(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        if (this.shouldUseJwtTokenWhenAttachmentNotFound(request)) {
            this.redirectToImageWithDenialReason(response);
        } else {
            log.error(String.format("Error finding %s : %s", request.getPathInfo(), ex.getMessage()));
            this.send404(response);
        }
    }

    private void copyStream(InputStream input, OutputStream out, Optional<RangeResponse> rangeResponse) throws IOException {
        if (rangeResponse.isPresent()) {
            this.copyRange(input, out, rangeResponse.get());
        } else {
            this.copyAll(input, out);
        }
    }

    private Optional<RangeResponse> createRangeResponse(HttpServletRequest request, String attachmentPath) throws BadRequestException, RangeNotSatisfiableException {
        if (this.supportsRangeRequests()) {
            RangeRequest rangeRequest = this.parseRangeHeader(request);
            return rangeRequest == null ? Optional.empty() : Optional.of(rangeRequest.calculateRangeResponse(this.getContentLength(attachmentPath)));
        }
        return Optional.empty();
    }

    private void redirectToImageWithDenialReason(HttpServletResponse response) throws IOException {
        response.sendRedirect(this.applicationPropertiesSupplier.get().getJiraBaseUrl() + IMAGE_DISPLAYING_CANNOT_DISPLAY_IMAGE_PATH);
    }

    private void send400(HttpServletResponse response, BadRequestException ex) throws IOException {
        response.sendError(400, ex.getMessage());
    }

    private void send416(HttpServletResponse response, RangeNotSatisfiableException ex) throws IOException {
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("Content-Range", "bytes */" + ex.getActualContentLength());
        response.sendError(416, ex.getMessage());
    }

    protected abstract int getContentLength(String var1);

    protected abstract boolean supportsRangeRequests();

    @VisibleForTesting
    protected void copyRange(InputStream is, OutputStream out, RangeResponse rangeResponse) throws IOException {
        int idx;
        is.skip(idx);
        if (rangeResponse.getEndIndex() == null) {
            IOUtils.copy((InputStream)is, (OutputStream)out);
        } else {
            int numBytesRead;
            int endIndex = rangeResponse.getEndIndex();
            byte[] buffer = new byte[4096];
            for (idx = rangeResponse.getStartIndex(); idx <= endIndex; idx += numBytesRead) {
                int numBytesWanted = Math.min(4096, endIndex - idx + 1);
                numBytesRead = is.read(buffer, 0, numBytesWanted);
                if (numBytesRead == -1) {
                    return;
                }
                out.write(buffer, 0, numBytesRead);
            }
        }
    }

    private void copyAll(InputStream is, OutputStream out) throws IOException {
        IOUtils.copy((InputStream)is, (OutputStream)out);
    }

    @Nullable
    private RangeRequest parseRangeHeader(HttpServletRequest request) throws BadRequestException {
        String headerValue = request.getHeader("Range");
        if (headerValue == null) {
            return null;
        }
        return RangeRequest.parse(headerValue);
    }

    protected final String attachmentQuery(HttpServletRequest request) {
        String pi = request.getPathInfo();
        if (pi == null || pi.length() == 1 || pi.indexOf(47, 1) == -1) {
            throw new InvalidAttachmentPathException();
        }
        return pi;
    }

    protected Attachment getAttachment(String queryWithIdAndFilenameToIgnore) {
        Long id;
        int x = queryWithIdAndFilenameToIgnore.indexOf(47, 1);
        String idStr = queryWithIdAndFilenameToIgnore.substring(1, x);
        try {
            id = new Long(idStr);
        }
        catch (NumberFormatException e) {
            throw new AttachmentNotFoundException((Object)idStr);
        }
        if (queryWithIdAndFilenameToIgnore.indexOf(47, x + 1) != -1) {
            throw new AttachmentNotFoundException((Object)idStr);
        }
        return this.attachmentManagerSupplier.get().getAttachment(id);
    }

    protected boolean isLoggedInUserPermittedToViewAttachment(Attachment attachment) {
        return this.isUserPermittedToViewAttachment(this.getLoggedInUser(), attachment);
    }

    private String getAbsoluteUrl(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    private void sendJwtTokenAnalyticsEvent(String encryptedToken, ImageAttachmentJwtToken token) {
        long tokenAgeSeconds = token.getTokenAgeSeconds(this.currentTimeMillis.getAsLong());
        String userEmailAttachmentKey = DigestUtils.md5Hex((String)encryptedToken);
        this.eventPublisherSupplier.get().publish((Object)new NotificationEmailAttachmentLoadedAnalyticsEvent(userEmailAttachmentKey, tokenAgeSeconds));
    }

    protected boolean isJwtTokenUserPermittedToViewAttachment_andSendAnalyticsEvent(HttpServletRequest request, Attachment attachment) {
        String token = this.getAttachmentJwtToken(request);
        try {
            ImageAttachmentJwtToken jwtToken = this.imageAttachmentJwtTokenServiceSupplier.get().parseToken(token);
            this.sendJwtTokenAnalyticsEvent(token, jwtToken);
            if (jwtToken.isTokenValid() && jwtToken.isMatchingUrl(this.getAbsoluteUrl(request))) {
                String userName = jwtToken.getUserName();
                ApplicationUser user = this.userManagerSupplier.get().getUserByName(userName);
                return this.isUserPermittedToViewAttachment(user, attachment);
            }
            return false;
        }
        catch (ImageAttachmentJwtGenerateSecretException | ImageAttachmentJwtParseException | ImageAttachmentJwtSecurityException e) {
            return false;
        }
    }

    protected boolean isUserPermittedToViewAttachment(ApplicationUser user, Attachment attachment) {
        Issue issue = attachment.getIssue();
        return issue != null && this.permissionManagerSupplier.get().hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, user);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkRequesterIsPermittedToViewTheAttachment(Attachment attachment, HttpServletRequest request, String exceptionMessage) throws PermissionException {
        if (this.isUserLoggedIn()) {
            if (this.isLoggedInUserPermittedToViewAttachment(attachment)) return;
            if (!this.shouldUseJwtTokenWhenAttachmentNotFound(attachment, request)) throw new PermissionException(exceptionMessage);
            if (this.isJwtTokenUserPermittedToViewAttachment_andSendAnalyticsEvent(request, attachment)) return;
            throw new JwtAttachmentPermissionException(exceptionMessage);
        }
        if (this.isAnonymousUserPermittedToViewAttachment(attachment)) return;
        if (!this.shouldUseJwtTokenWhenAttachmentNotFound(attachment, request)) throw new PermissionException(exceptionMessage);
        if (this.isJwtTokenUserPermittedToViewAttachment_andSendAnalyticsEvent(request, attachment)) return;
        throw new JwtAttachmentPermissionException(exceptionMessage);
    }

    private boolean shouldUseJwtTokenWhenAttachmentNotFound(Attachment attachment, HttpServletRequest request) {
        return this.imageAttachmentJwtTokenServiceSupplier.get().isImageAttachmentJwtTokenEnabled() && attachment.isImage() && this.isImageAttachmentJwtTokenPresent(request);
    }

    private boolean shouldUseJwtTokenWhenAttachmentNotFound(HttpServletRequest request) {
        return this.imageAttachmentJwtTokenServiceSupplier.get().isImageAttachmentJwtTokenEnabled() && this.isImageAttachmentJwtTokenPresent(request);
    }

    protected abstract void getInputStream(HttpServletRequest var1, String var2, InputStreamConsumer<Unit> var3) throws IOException, PermissionException;

    protected abstract void setResponseContentHeaders(HttpServletRequest var1, Optional<RangeResponse> var2, HttpServletResponse var3, Optional<Long> var4);

    protected boolean isUserLoggedIn() {
        return this.jiraAuthenticationContextSupplier.get().isLoggedInUser();
    }

    protected final ApplicationUser getLoggedInUser() {
        return this.jiraAuthenticationContextSupplier.get().getLoggedInUser();
    }

    protected final boolean isAnonymousUserPermittedToViewAttachment(Attachment attachment) {
        Issue issue = attachment.getIssue();
        return issue != null && this.permissionManagerSupplier.get().hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, ANONYMOUS_USER);
    }

    private String getAttachmentJwtToken(HttpServletRequest request) {
        return request.getParameter(IMAGE_ATTACHMENT_JWT_TOKEN_QUERY_PARAM_NAME);
    }

    protected boolean isImageAttachmentJwtTokenPresent(HttpServletRequest request) {
        return this.getAttachmentJwtToken(request) != null;
    }

    public static class JwtAttachmentPermissionException
    extends PermissionException {
        public JwtAttachmentPermissionException(String msg) {
            super(msg);
        }
    }
}

