/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet.viewfile;

import com.atlassian.jira.web.servlet.BadRequestException;
import com.atlassian.jira.web.servlet.RangeNotSatisfiableException;
import com.atlassian.jira.web.servlet.viewfile.RangeResponse;
import javax.annotation.Nullable;

public class RangeRequest {
    private final Integer startIndex;
    private final Integer endIndex;

    public RangeRequest(Integer startIndex, Integer endIndex) {
        if (startIndex == null && endIndex == null) {
            throw new IllegalArgumentException("Must have at least one non-null value");
        }
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    @Nullable
    public static RangeRequest parse(String headerValue) throws BadRequestException {
        String text = headerValue.trim();
        if (!text.startsWith("bytes=")) {
            return null;
        }
        text = text.substring(6);
        int idx = text.indexOf(",");
        if (idx > -1) {
            text = text.substring(0, idx);
        }
        if (text.endsWith("-")) {
            if (text.trim().equals("-")) {
                throw new BadRequestException("Malformed Range header");
            }
            return new RangeRequest(RangeRequest.parseInt(text.substring(0, text.length() - 1)), null);
        }
        String[] split = text.split("-");
        if (split.length != 2) {
            throw new BadRequestException("Malformed Range header");
        }
        return new RangeRequest(RangeRequest.parseInt(split[0].trim()), RangeRequest.parseInt(split[1].trim()));
    }

    private static Integer parseInt(String text) throws BadRequestException {
        if (text.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("Malformed Range header");
        }
    }

    RangeResponse calculateRangeResponse(int totalFileLength) throws RangeNotSatisfiableException {
        if (this.startIndex == null) {
            int numberOfBytesRequested = this.getEndIndex();
            if (totalFileLength < numberOfBytesRequested) {
                return new RangeResponse(0, totalFileLength - 1, totalFileLength);
            }
            return new RangeResponse(totalFileLength - numberOfBytesRequested, totalFileLength - 1, totalFileLength);
        }
        if (this.startIndex < totalFileLength) {
            return new RangeResponse(this.startIndex, this.endIndex, totalFileLength);
        }
        throw new RangeNotSatisfiableException("Cannot return request range '" + this.toString() + "'. Attachment has only " + totalFileLength + " bytes", totalFileLength);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeRequest that = (RangeRequest)o;
        if (this.startIndex != null ? !this.startIndex.equals(that.startIndex) : that.startIndex != null) {
            return false;
        }
        return !(this.endIndex != null ? !this.endIndex.equals(that.endIndex) : that.endIndex != null);
    }

    public int hashCode() {
        int result = this.startIndex != null ? this.startIndex.hashCode() : 0;
        result = 31 * result + (this.endIndex != null ? this.endIndex.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "bytes=" + this.format(this.startIndex) + "-" + this.format(this.endIndex);
    }

    private String format(Integer index) {
        return index == null ? "" : index.toString();
    }
}

