/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.startup;

import com.atlassian.jira.component.ComponentContainerState;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.util.johnson.JohnsonEventPredicates;
import com.atlassian.jira.web.startup.StartupPageSupport;
import com.atlassian.johnson.Johnson;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StartupServlet
extends HttpServlet {
    static final String ACCEPT = "Accept";
    static final String APPLICATION_JSON = "application/json";
    static final String TEXT_HTML = "text/html";
    static final String CHARSET_UTF_8 = ";charset=UTF-8";
    static final JsonFactory JSON = new MappingJsonFactory();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (APPLICATION_JSON.equals(request.getHeader(ACCEPT))) {
            this.respondWithJson(request, response);
        } else if (this.hasJohnsonEventThatBlocksStartup(request) || this.getCurrentState().isStarted()) {
            StartupPageSupport.returnFromStartupJsp(request, response);
        } else {
            response.setContentType("text/html;charset=UTF-8");
            response.setStatus(503);
            this.includeStartupJsp(request, response);
        }
    }

    private void respondWithJson(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.hasJohnsonEventThatBlocksStartup(request)) {
            response.setStatus(500);
            response.getWriter().flush();
        } else {
            ComponentContainerState state = this.getCurrentState();
            response.setStatus(200);
            response.setContentType("application/json;charset=UTF-8");
            this.writeJson(request, response, state);
        }
    }

    @VisibleForTesting
    protected void writeJson(HttpServletRequest request, HttpServletResponse response, ComponentContainerState state) throws IOException {
        try (JsonGenerator jsonGenerator = JSON.createJsonGenerator((OutputStream)response.getOutputStream(), JsonEncoding.UTF8);){
            jsonGenerator.writeObject((Object)ImmutableMap.of((Object)"progress", (Object)ImmutableMap.of((Object)"message", (Object)StartupPageSupport.getTranslator(request).apply(state.getMessageKey()), (Object)"percentage", (Object)state.getPercentage()), (Object)"state", (Object)((Object)state)));
        }
    }

    @VisibleForTesting
    protected ComponentContainerState getCurrentState() {
        ComponentContainerState state = ComponentManager.getInstance().getState();
        if (state.isStarted() && !StartupPageSupport.isLaunched()) {
            return ComponentContainerState.COMPONENTS_INSTANTIATED;
        }
        return state;
    }

    @VisibleForTesting
    protected boolean hasJohnsonEventThatBlocksStartup(HttpServletRequest request) {
        return Johnson.getEventContainer((ServletContext)request.getServletContext()).hasEvent(JohnsonEventPredicates.blocksStartup());
    }

    @VisibleForTesting
    protected void includeStartupJsp(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.getRequestDispatcher("/startup.jsp").include((ServletRequest)request, (ServletResponse)response);
    }
}

