/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.i18n.terminology.TerminologyEntry;
import com.atlassian.jira.i18n.terminology.TerminologyEntryReader;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class TerminologyDataProvider
implements WebResourceDataProvider {
    private final FeatureManager featureManager;
    private TerminologyEntryReader terminologyEntryReader;
    private static final Logger log = LoggerFactory.getLogger(TerminologyDataProvider.class);
    private static final String IS_TERMINOLOGY_ACTIVE = "isTerminologyActive";
    private static final String TERMINOLOGY_ENTRIES = "terminologyEntries";
    private static final String TERM_ORIGINAL_NAME = "originalName";
    private static final String TERM_ORIGINAL_NAME_PLURAL = "originalNamePlural";
    private static final String TERM_NEW_NAME = "newName";
    private static final String TERM_NEW_NAME_PLURAL = "newNamePlural";
    private static final String TERM_IS_DEFAULT = "isDefault";

    public TerminologyDataProvider(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public Collection<TerminologyEntry> getTerminologyEntries() {
        TerminologyEntryReader terminologyEntryReader = this.getTerminologyEntryReader();
        if (terminologyEntryReader == null) {
            return Collections.emptyList();
        }
        return terminologyEntryReader.getAllTerminologyEntries();
    }

    public boolean isTerminologyActive(Collection<TerminologyEntry> terminologyEntries) {
        return terminologyEntries.stream().anyMatch(TerminologyEntry::hasNonOriginalNames);
    }

    public List<JSONObject> getTerminologyEntriesAsJson(Collection<TerminologyEntry> terminologyEntries) {
        return terminologyEntries.stream().map(terminologyEntry -> {
            try {
                return this.getTerminologyEntryAsJson((TerminologyEntry)terminologyEntry);
            }
            catch (JSONException e) {
                log.error(e.getMessage());
                return null;
            }
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    public JSONObject getTerminologyEntryAsJson(@NonNull TerminologyEntry terminologyEntry) throws JSONException {
        JSONObject values = new JSONObject();
        values.put(TERM_ORIGINAL_NAME, (Object)terminologyEntry.getOriginalName());
        values.put(TERM_ORIGINAL_NAME_PLURAL, (Object)terminologyEntry.getOriginalNamePlural());
        values.put(TERM_NEW_NAME, (Object)terminologyEntry.getNewName());
        values.put(TERM_NEW_NAME_PLURAL, (Object)terminologyEntry.getNewNamePlural());
        values.put(TERM_IS_DEFAULT, !terminologyEntry.hasNonOriginalNames());
        return values;
    }

    public Jsonable get() {
        return writer -> {
            try {
                this.getJsonData().write(writer);
            }
            catch (JSONException e) {
                throw new Jsonable.JsonMappingException((Throwable)e);
            }
        };
    }

    private JSONObject getJsonData() throws JSONException {
        Collection<TerminologyEntry> terminologyEntries;
        JSONObject values = new JSONObject();
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.TERMINOLOGY_CHANGES) && !(terminologyEntries = this.getTerminologyEntries()).isEmpty()) {
            values.put(TERMINOLOGY_ENTRIES, this.getTerminologyEntriesAsJson(terminologyEntries));
            values.put(IS_TERMINOLOGY_ACTIVE, this.isTerminologyActive(terminologyEntries));
        }
        return values;
    }

    private TerminologyEntryReader getTerminologyEntryReader() {
        if (this.terminologyEntryReader == null) {
            this.terminologyEntryReader = TerminologyDataProvider.getComponentOrNull(TerminologyEntryReader.class);
        }
        return this.terminologyEntryReader;
    }

    private static <T> T getComponentOrNull(Class<T> clazz) {
        Option componentOption = Option.option(ComponentAccessor.getComponentSafely(clazz).orElse(null));
        return (T)componentOption.getOrNull();
    }
}

