/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.function.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.FieldValuesChangedEvent;
import com.atlassian.jira.event.commit.OnCommitEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.issue.commit.OnCommitJiraIssueEventBuilder;
import com.atlassian.jira.event.issue.txnaware.TxnAwareEventFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.GenericValue;

public class FireIssueEventFunction
implements FunctionProvider {
    public void execute(Map transientVars, Map args, PropertySet ps) {
        Object object = args.get("eventTypeId");
        Long eventTypeId = object instanceof Long ? (Long)args.get("eventTypeId") : (object instanceof String ? new Long((String)object) : null);
        if (eventTypeId != null) {
            Issue updatedIssue = (Issue)transientVars.get("issue");
            Comment comment = (Comment)transientVars.get("commentValue");
            GenericValue changeGroup = (GenericValue)transientVars.get("changeGroup");
            String originalAssigneeId = (String)transientVars.get("originalAssigneeId");
            Map modifiedFields = Optional.ofNullable((Map)transientVars.get("modifiedFields")).orElse(Collections.EMPTY_MAP);
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("eventsource", "workflow");
            boolean sendMail = transientVars.get("sendBulkNotification") == null || this.getBool(transientVars, "sendBulkNotification");
            ApplicationUser caller = WorkflowUtil.getCallerUser((Map)transientVars);
            this.getIssueEventManager().dispatchRedundantEvent(eventTypeId, updatedIssue, caller, comment, null, changeGroup, params, sendMail);
            this.getEventPublisher().publish((Object)new FieldValuesChangedEvent(updatedIssue, modifiedFields, true));
            IssueEventBundle eventBundle = this.getIssueEventBundleFactory().createWorkflowEventBundle(eventTypeId, updatedIssue, caller, comment, changeGroup, params, sendMail, originalAssigneeId);
            this.getIssueEventManager().dispatchIssueEventBundle(eventBundle, false);
            this.getIssueEventManager().dispatchIssueEventBundleOnCommit(() -> {
                MutableIssue reloadedIssue = updatedIssue != null ? this.getIssueManager().getIssueObject(updatedIssue.getId()) : null;
                GenericValue reloadedChangeGroup = changeGroup != null ? this.getOfBizDelegator().findById("ChangeGroup", changeGroup.getLong("id")) : null;
                Comment updatedComment = comment != null ? this.getCommentManager().getCommentById(comment.getId()) : null;
                IssueEventBundle workflowEventBundle = this.getIssueEventBundleFactory().createWorkflowEventBundle(eventTypeId, (Issue)reloadedIssue, caller, updatedComment, reloadedChangeGroup, params, sendMail, originalAssigneeId);
                List onCommitJiraIssueEvents = workflowEventBundle.getEvents().stream().filter(Objects::nonNull).map(jiraIssueEvent -> OnCommitJiraIssueEventBuilder.builder(jiraIssueEvent).setOnCommitEventDataReloadStatus(OnCommitEvent.OnCommitEventDataReloadStatus.RELOADED_ON_COMMIT).build()).collect(Collectors.toList());
                return () -> onCommitJiraIssueEvents;
            });
            if (changeGroup != null) {
                this.getTxnAwareEventFactory().issueChangedEventOnCommit(updatedIssue.getId(), caller, comment, changeGroup.getLong("id"), sendMail);
            }
        }
    }

    private boolean getBool(Map transientVars, String name) {
        return (Boolean)transientVars.get(name);
    }

    private IssueEventManager getIssueEventManager() {
        return ComponentAccessor.getIssueEventManager();
    }

    private IssueEventBundleFactory getIssueEventBundleFactory() {
        return (IssueEventBundleFactory)ComponentAccessor.getComponent(IssueEventBundleFactory.class);
    }

    private IssueManager getIssueManager() {
        return ComponentAccessor.getIssueManager();
    }

    private OfBizDelegator getOfBizDelegator() {
        return ComponentAccessor.getOfBizDelegator();
    }

    private CommentManager getCommentManager() {
        return ComponentAccessor.getCommentManager();
    }

    private TxnAwareEventFactory getTxnAwareEventFactory() {
        return (TxnAwareEventFactory)ComponentAccessor.getComponent(TxnAwareEventFactory.class);
    }

    private EventPublisher getEventPublisher() {
        return (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
    }

    public static FunctionDescriptor makeDescriptor(Long eventTypeId) {
        FunctionDescriptor descriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
        descriptor.setType("class");
        descriptor.getArgs().put("class.name", FireIssueEventFunction.class.getName());
        descriptor.getArgs().put("eventTypeId", eventTypeId);
        return descriptor;
    }
}

