/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.check.EntityCheckImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.appconsistency.integrity.transformer.DeleteEntityAmendmentTransformer;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.ofbiz.core.entity.GenericValue;

public class IssueLinkCheck
extends EntityCheckImpl {
    public IssueLinkCheck(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getCorruptIssueLinks() throws IntegrityException {
        HashSet<String> validIssueIds = new HashSet<String>();
        try (OfBizListIterator issues = null;){
            issues = this.getEntities("Issue");
            GenericValue issue = issues.next();
            while (issue != null) {
                validIssueIds.add(issue.getString("id"));
                issue = issues.next();
            }
        }
        ArrayList<GenericValue> corruptIssueLinks = new ArrayList<GenericValue>();
        try (OfBizListIterator issueLinks = null;){
            issueLinks = this.getEntities("IssueLink");
            GenericValue issueLink = issueLinks.next();
            while (issueLink != null) {
                String sourceId = issueLink.getString("source");
                String destinationId = issueLink.getString("destination");
                if (!validIssueIds.contains(sourceId) || !validIssueIds.contains(destinationId)) {
                    corruptIssueLinks.add(issueLink);
                }
                issueLink = issueLinks.next();
            }
        }
        return corruptIssueLinks;
    }

    @Override
    public List preview() throws IntegrityException {
        List amendments = this.getCorruptIssueLinks();
        CollectionUtils.transform((Collection)amendments, (Transformer)new DeleteEntityAmendmentTransformer(2, this.getI18NBean().getText("admin.integrity.check.issue.link.preview")));
        return new ArrayList(amendments);
    }

    @Override
    public List correct() throws IntegrityException {
        List corruptIssueLinks = this.getCorruptIssueLinks();
        if (!corruptIssueLinks.isEmpty()) {
            try {
                this.ofBizDelegator.removeAll(corruptIssueLinks);
            }
            catch (Exception e) {
                throw new IntegrityException(e);
            }
        }
        CollectionUtils.transform((Collection)corruptIssueLinks, (Transformer)new DeleteEntityAmendmentTransformer(0, this.getI18NBean().getText("admin.integrity.check.issue.link.message")));
        return new ArrayList(corruptIssueLinks);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.issue.link.desc");
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

