/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application.install;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.install.ApplicationInstaller;
import com.atlassian.plugin.event.events.PluginFrameworkStartingEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInstallListener {
    private static final Logger log = LoggerFactory.getLogger(ApplicationInstallListener.class);
    private final EventPublisher eventPublisher;
    private final ApplicationInstaller installer;
    private final AtomicBoolean wasInstallationPerformed = new AtomicBoolean(false);

    public ApplicationInstallListener(EventPublisher eventPublisher, ApplicationInstaller installer) {
        this.eventPublisher = eventPublisher;
        this.installer = installer;
    }

    public void register() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onPluginSystemStarting(PluginFrameworkStartingEvent event) {
        try {
            if (this.wasInstallationPerformed.compareAndSet(false, true)) {
                this.installer.installApplications();
            }
        }
        catch (Exception e) {
            log.error("Failed to install applications", (Throwable)e);
        }
    }
}

