/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuditingEntry {
    @Nonnull
    private final AuditingCategory category;
    @Nonnull
    private final String summaryI18nKey;
    @Nonnull
    private final String eventSource;
    private final boolean isAuthorSysAdmin;
    @Nullable
    private final String categoryName;
    @Nullable
    private final ApplicationUser author;
    @Nullable
    private final String remoteAddress;
    @Nullable
    private final AssociatedItem associatedItem;
    @Nullable
    private final Iterable<ChangedValue> changedValues;
    @Nullable
    private final Iterable<AssociatedItem> associatedItems;
    @Nullable
    private final String description;

    public static Builder builder(@Nonnull AuditingCategory category, @Nonnull String summaryI18nKey, @Nonnull String eventSource) {
        return new Builder(category, summaryI18nKey, eventSource);
    }

    private AuditingEntry(Builder builder) {
        this.category = builder.category;
        this.categoryName = builder.categoryName;
        this.summaryI18nKey = builder.summaryI18nKey;
        this.eventSource = builder.eventSource;
        this.author = builder.author;
        this.remoteAddress = builder.remoteAddress;
        this.associatedItem = builder.associatedObject;
        this.changedValues = builder.changedValues;
        this.associatedItems = builder.associatedItems;
        this.isAuthorSysAdmin = builder.isAuthorSysAdmin;
        this.description = builder.description;
    }

    @Nonnull
    public AuditingCategory category() {
        return this.category;
    }

    @Nonnull
    public String summaryI18nKey() {
        return this.summaryI18nKey;
    }

    @Nonnull
    public String eventSource() {
        return this.eventSource;
    }

    public boolean authorIsSysAdmin() {
        return this.isAuthorSysAdmin;
    }

    @Nullable
    public String categoryName() {
        return this.categoryName;
    }

    @Nullable
    public ApplicationUser author() {
        return this.author;
    }

    @Nullable
    public String remoteAddress() {
        return this.remoteAddress;
    }

    @Nullable
    public AssociatedItem objectItem() {
        return this.associatedItem;
    }

    @Nullable
    public Iterable<ChangedValue> changedValues() {
        return this.changedValues;
    }

    @Nullable
    public Iterable<AssociatedItem> associatedItems() {
        return this.associatedItems;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public static class Builder {
        private final AuditingCategory category;
        private final String summaryI18nKey;
        private final String eventSource;
        private boolean isAuthorSysAdmin;
        private String categoryName;
        private ApplicationUser author;
        private String remoteAddress;
        private AssociatedItem associatedObject;
        private Iterable<ChangedValue> changedValues;
        private Iterable<AssociatedItem> associatedItems;
        private String description;

        public Builder(@Nonnull AuditingCategory category, @Nonnull String summaryI18nKey, @Nonnull String eventSource) {
            this.category = (AuditingCategory)Assertions.notNull((String)"category", (Object)category);
            this.summaryI18nKey = (String)Assertions.notNull((String)"summaryI18nKey", (Object)summaryI18nKey);
            this.eventSource = (String)Assertions.notNull((String)"eventSource", (Object)eventSource);
        }

        public Builder categoryName(String name) {
            this.categoryName = name;
            return this;
        }

        public Builder author(ApplicationUser author) {
            this.author = author;
            return this;
        }

        public Builder remoteAddress(String remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        public Builder objectItem(AssociatedItem object) {
            this.associatedObject = object;
            return this;
        }

        public Builder changedValues(Iterable<ChangedValue> changedValues) {
            this.changedValues = changedValues;
            return this;
        }

        public Builder associatedItems(Iterable<AssociatedItem> items) {
            this.associatedItems = items;
            return this;
        }

        public Builder isAuthorSysAdmin(boolean isAuthorSysAdmin) {
            this.isAuthorSysAdmin = isAuthorSysAdmin;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public AuditingEntry build() {
            return new AuditingEntry(this);
        }
    }
}

