/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.NotificationChangeHandler;
import com.atlassian.jira.event.notification.NotificationAddedEvent;
import com.atlassian.jira.event.notification.NotificationDeletedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEntityEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.notification.NotificationType;
import com.atlassian.jira.notification.NotificationTypeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.util.I18nHelper;
import java.util.List;
import java.util.Locale;

public class NotificationChangeHandlerImpl
implements NotificationChangeHandler {
    public static final String SCHEME_UPDATED_I18N_KEY = "jira.auditing.notification.scheme.updated";
    private final NotificationSchemeManager notificationSchemeManager;
    private final NotificationTypeManager notificationTypeManager;
    private final EventTypeManager eventTypeManager;
    private final I18nHelper.BeanFactory i18n;

    public NotificationChangeHandlerImpl(NotificationSchemeManager notificationSchemeManager, NotificationTypeManager notificationTypeManager, EventTypeManager eventTypeManager, I18nHelper.BeanFactory i18n) {
        this.notificationSchemeManager = notificationSchemeManager;
        this.notificationTypeManager = notificationTypeManager;
        this.eventTypeManager = eventTypeManager;
        this.i18n = i18n;
    }

    @Override
    public RecordRequest onNotificationAddedEvent(NotificationAddedEvent event) {
        Scheme scheme = this.notificationSchemeManager.getSchemeObject(event.getSchemeId());
        return new RecordRequest(AuditingCategory.NOTIFICATIONS, SCHEME_UPDATED_I18N_KEY).forObject(AssociatedItem.Type.SCHEME, scheme.getName(), scheme.getId()).withChangedValues(this.computeChangedValues((AbstractSchemeEntityEvent)event));
    }

    @Override
    public RecordRequest onNotificationDeletedEvent(NotificationDeletedEvent event) {
        Scheme scheme = this.notificationSchemeManager.getSchemeObject(event.getSchemeId());
        return new RecordRequest(AuditingCategory.NOTIFICATIONS, SCHEME_UPDATED_I18N_KEY).forObject(AssociatedItem.Type.SCHEME, scheme.getName(), scheme.getId()).withChangedValues(this.computeChangedValues((AbstractSchemeEntityEvent)event));
    }

    private List<ChangedValue> computeChangedValues(AbstractSchemeEntityEvent event) {
        NotificationType schemeType = (NotificationType)this.notificationTypeManager.getSchemeType(event.getType());
        Long eventTypeId = this.unboxNumber(event.getEntityTypeId());
        String eventName = ((EventType)this.eventTypeManager.getEventTypesMap().get(eventTypeId)).getName();
        String receiverType = schemeType.getDisplayName();
        String receiverName = StringUtils.defaultString((String)(event.getParameter() != null ? schemeType.getArgumentDisplay(event.getParameter()) : ""), (String)"");
        if ("group".equals(event.getType()) && StringUtils.isEmpty((String)receiverName)) {
            receiverName = this.getI18n().getText("common.sharing.shared.description.anyone");
        }
        ChangedValuesBuilder builder = new ChangedValuesBuilder();
        if (event instanceof NotificationAddedEvent) {
            builder.addIfDifferent("admin.common.words.event", "", eventName).addIfDifferent("admin.common.words.type", "", receiverType).addIfDifferent("admin.common.words.value", "", receiverName);
        } else if (event instanceof NotificationDeletedEvent) {
            builder.addIfDifferent("admin.common.words.event", eventName, "").addIfDifferent("admin.common.words.type", receiverType, "").addIfDifferent("admin.common.words.value", receiverName, "");
        } else {
            throw new UnsupportedOperationException("Missing handler for " + event.getClass().getSimpleName());
        }
        return builder.build();
    }

    protected I18nHelper getI18n() {
        return this.i18n.getInstance(Locale.ENGLISH);
    }

    private Long unboxNumber(Object number) {
        return Long.valueOf(number.toString());
    }
}

