/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.fugue.Option;
import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.PermissionChangeHandler;
import com.atlassian.jira.event.permission.GlobalPermissionAddedEvent;
import com.atlassian.jira.event.permission.GlobalPermissionDeletedEvent;
import com.atlassian.jira.event.permission.PermissionAddedEvent;
import com.atlassian.jira.event.permission.PermissionDeletedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEntityEvent;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Locale;

public class PermissionChangeHandlerImpl
implements PermissionChangeHandler {
    private final PermissionSchemeManager permissionSchemeManager;
    private final PermissionManager permissionManager;
    private final PermissionTypeManager permissionTypeManager;
    private final I18nHelper.BeanFactory i18n;

    public PermissionChangeHandlerImpl(PermissionSchemeManager permissionSchemeManager, PermissionManager permissionManager, PermissionTypeManager permissionTypeManager, I18nHelper.BeanFactory i18n) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.permissionManager = permissionManager;
        this.permissionTypeManager = permissionTypeManager;
        this.i18n = i18n;
    }

    @Override
    public RecordRequest onPermissionAddedEvent(PermissionAddedEvent event) {
        Scheme scheme = this.permissionSchemeManager.getSchemeObject(event.getSchemeId());
        return new RecordRequest(AuditingCategory.PERMISSIONS, "jira.auditing.permission.scheme.updated").forObject(AssociatedItem.Type.SCHEME, scheme.getName(), scheme.getId()).withChangedValues(this.computeChangedValues((AbstractSchemeEntityEvent)event));
    }

    @Override
    public RecordRequest onPermissionDeletedEvent(PermissionDeletedEvent event) {
        Scheme scheme = this.permissionSchemeManager.getSchemeObject(event.getSchemeId());
        return new RecordRequest(AuditingCategory.PERMISSIONS, "jira.auditing.permission.scheme.updated").forObject(AssociatedItem.Type.SCHEME, scheme.getName(), scheme.getId()).withChangedValues(this.computeChangedValues((AbstractSchemeEntityEvent)event));
    }

    @Override
    public RecordRequest onGlobalPermissionAddedEvent(GlobalPermissionAddedEvent event) {
        String groupName = StringUtils.defaultString((String)event.getGroup(), (String)this.getI18n().getText("admin.common.words.anyone"));
        String permissionName = this.getPermissionName(event.getGlobalPermissionType());
        return new RecordRequest(AuditingCategory.PERMISSIONS, "jira.auditing.global.permission.added").forObject(AssociatedItem.Type.PERMISSIONS, this.getI18n().getText("jira.auditing.global.permissions")).withChangedValues(new ChangedValuesBuilder().addIfDifferent("admin.common.words.permission", "", permissionName).addIfDifferent("admin.common.words.group", "", groupName).build());
    }

    @Override
    public RecordRequest onGlobalPermissionDeletedEvent(GlobalPermissionDeletedEvent event) {
        String groupName = StringUtils.defaultString((String)event.getGroup(), (String)this.getI18n().getText("admin.common.words.anyone"));
        String permissionName = this.getPermissionName(event.getGlobalPermissionType());
        return new RecordRequest(AuditingCategory.PERMISSIONS, "jira.auditing.global.permission.deleted").forObject(AssociatedItem.Type.PERMISSIONS, this.getI18n().getText("jira.auditing.global.permissions")).withChangedValues(new ChangedValuesBuilder().addIfDifferent("admin.common.words.permission", permissionName, "").addIfDifferent("admin.common.words.group", groupName, "").build());
    }

    private String getPermissionName(GlobalPermissionType globalPermissionType) {
        return this.getI18n().getText(globalPermissionType.getNameI18nKey());
    }

    @VisibleForTesting
    protected List<ChangedValue> computeChangedValues(AbstractSchemeEntityEvent event) {
        if (!(event.getEntityTypeId() instanceof ProjectPermissionKey)) {
            throw new IllegalArgumentException("EntityTypeId must be a ProjectPermissionKey, not " + event.getEntityTypeId().getClass());
        }
        ProjectPermissionKey permissionKey = (ProjectPermissionKey)event.getEntityTypeId();
        SecurityType schemeType = (SecurityType)this.permissionTypeManager.getSchemeType(event.getType());
        String permissionName = this.getPermissionName(permissionKey);
        String receiverType = schemeType.getDisplayName();
        String receiverName = StringUtils.defaultString((String)(event.getParameter() != null ? schemeType.getArgumentDisplay(event.getParameter()) : ""), (String)"");
        if ("group".equals(event.getType()) && StringUtils.isEmpty((String)receiverName)) {
            receiverName = this.getI18n().getText("common.sharing.shared.description.anyone");
        }
        ChangedValuesBuilder builder = new ChangedValuesBuilder();
        if (event instanceof PermissionAddedEvent) {
            builder.addIfDifferent("admin.common.words.permission", "", permissionName).addIfDifferent("admin.common.words.type", "", receiverType).addIfDifferent("admin.common.words.value", "", receiverName);
        } else if (event instanceof PermissionDeletedEvent) {
            builder.addIfDifferent("admin.common.words.permission", permissionName, "").addIfDifferent("admin.common.words.type", receiverType, "").addIfDifferent("admin.common.words.value", receiverName, "");
        } else {
            throw new UnsupportedOperationException("Missing handler for " + event.getClass().getSimpleName());
        }
        return builder.build();
    }

    @VisibleForTesting
    protected String getPermissionName(ProjectPermissionKey permissionKey) {
        Option permission = this.permissionManager.getProjectPermission(permissionKey);
        return permission.isDefined() ? this.getI18n().getText(((ProjectPermission)permission.get()).getNameI18nKey()) : "";
    }

    protected I18nHelper getI18n() {
        return this.i18n.getInstance(Locale.ENGLISH);
    }

    private Long unboxNumber(Object number) {
        return Long.valueOf(number.toString());
    }
}

