/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.fugue.Option;
import com.atlassian.jira.auditing.AffectedProject;
import com.atlassian.jira.auditing.AffectedUser;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.HandlerUtils;
import com.atlassian.jira.auditing.handlers.ProjectComponentEventHandler;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentCreatedEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentDeletedEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentMergedEvent;
import com.atlassian.jira.event.bc.project.component.ProjectComponentUpdatedEvent;
import com.atlassian.jira.project.ComponentAssigneeTypes;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;

public class ProjectComponentEventHandlerImpl
implements ProjectComponentEventHandler {
    private final I18nHelper.BeanFactory i18n;
    private final ProjectManager projectManager;

    public ProjectComponentEventHandlerImpl(I18nHelper.BeanFactory i18n, ProjectManager projectManager) {
        this.i18n = i18n;
        this.projectManager = projectManager;
    }

    @Override
    public RecordRequest onProjectComponentCreatedEvent(ProjectComponentCreatedEvent event) {
        ProjectComponent component = event.getProjectComponent();
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.component.created").forObject(AssociatedItem.Type.PROJECT_COMPONENT, component.getName(), component.getId().toString()).withAssociatedItems(this.getAssociatedItems(component)).withChangedValues(this.buildChangedValues(component));
    }

    @Override
    public Option<RecordRequest> onProjectComponentUpdatedEvent(ProjectComponentUpdatedEvent event) {
        final ProjectComponent oldComponent = event.getOldProjectComponent();
        final ProjectComponent component = event.getProjectComponent();
        return HandlerUtils.requestIfThereAreAnyValues(this.buildChangedValues(oldComponent, component), new Function<List<ChangedValue>, RecordRequest>(){

            public RecordRequest apply(List<ChangedValue> changedValues) {
                return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.component.updated").forObject(AssociatedItem.Type.PROJECT_COMPONENT, component.getName(), component.getId().toString()).withAssociatedItems((Iterable)ProjectComponentEventHandlerImpl.this.getAssociatedItems(oldComponent, component)).withChangedValues(changedValues);
            }
        });
    }

    @Override
    public RecordRequest onProjectComponentMergedEvent(ProjectComponentMergedEvent event) {
        ProjectComponent component = event.getProjectComponent();
        ProjectComponent mergedComponent = event.getMergedProjectComponent();
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.component.merged").forObject(AssociatedItem.Type.PROJECT_COMPONENT, component.getName(), component.getId().toString()).withAssociatedItems(new AssociatedItem[]{new AffectedProject(this.getProjectOfComponent(component))}).withChangedValues(this.buildChangedValues(mergedComponent, component));
    }

    @Override
    public RecordRequest onProjectComponentDeletedEvent(ProjectComponentDeletedEvent event) {
        ProjectComponent component = event.getProjectComponent();
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.component.deleted").forObject(AssociatedItem.Type.PROJECT_COMPONENT, component.getName(), component.getId().toString()).withAssociatedItems(new AssociatedItem[]{new AffectedProject(this.getProjectOfComponent(component))});
    }

    private ImmutableList<AssociatedItem> getAssociatedItems(ProjectComponent component) {
        return this.getAssociatedItems(null, component);
    }

    private ImmutableList<AssociatedItem> getAssociatedItems(ProjectComponent oldComponent, ProjectComponent component) {
        ImmutableList.Builder associated = new ImmutableList.Builder();
        associated.add((Object)new AffectedProject(this.getProjectOfComponent(component)));
        associated.addAll(this.getAffectedUsers(oldComponent, component));
        return associated.build();
    }

    private Project getProjectOfComponent(ProjectComponent component) {
        return this.projectManager.getProjectObj(component.getProjectId());
    }

    private ImmutableList<AssociatedItem> getAffectedUsers(ProjectComponent oldComponent, ProjectComponent component) {
        Project project = this.getProjectOfComponent(component);
        long assigneeType = component.getAssigneeType();
        ApplicationUser componentLead = null;
        ApplicationUser defaultAssignee = null;
        if (oldComponent == null || oldComponent != null && !Objects.equal((Object)oldComponent.getLead(), (Object)component.getLead())) {
            componentLead = component.getComponentLead();
        }
        if (oldComponent == null || assigneeType != oldComponent.getAssigneeType()) {
            if (ComponentAssigneeTypes.isComponentLead(assigneeType)) {
                defaultAssignee = component.getComponentLead();
            } else if (ComponentAssigneeTypes.isProjectLead(assigneeType) || ComponentAssigneeTypes.isProjectDefault(assigneeType) && ProjectAssigneeTypes.isProjectLead((Long)project.getAssigneeType())) {
                defaultAssignee = project.getProjectLead();
            }
        }
        ImmutableList.Builder affected = new ImmutableList.Builder();
        if (componentLead != null) {
            affected.add((Object)new AffectedUser(componentLead));
            if (defaultAssignee != null && !componentLead.equals((Object)defaultAssignee)) {
                affected.add((Object)new AffectedUser(defaultAssignee));
            }
        } else if (defaultAssignee != null) {
            affected.add((Object)new AffectedUser(defaultAssignee));
        }
        return affected.build();
    }

    private List<ChangedValue> buildChangedValues(ProjectComponent component) {
        return this.buildChangedValues(null, component);
    }

    private List<ChangedValue> buildChangedValues(ProjectComponent oldComponent, ProjectComponent component) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("common.words.name", oldComponent == null ? null : oldComponent.getName(), component.getName());
        changedValues.addIfDifferent("common.concepts.description", oldComponent == null ? null : oldComponent.getDescription(), component.getDescription());
        changedValues.addIfDifferent("admin.projects.component.lead", oldComponent == null ? null : (oldComponent.getComponentLead() == null ? null : oldComponent.getComponentLead().getUsername()), component.getComponentLead() == null ? null : component.getComponentLead().getUsername());
        changedValues.addIfDifferent("admin.projects.default.assignee", oldComponent == null ? null : this.pre(oldComponent.getAssigneeType()), this.pre(component.getAssigneeType()));
        return changedValues.build();
    }

    private String pre(Long assigneeType) {
        return this.getI18n().getText(ComponentAssigneeTypes.getPrettyAssigneeType(assigneeType));
    }

    protected I18nHelper getI18n() {
        return this.i18n.getInstance(Locale.ENGLISH);
    }
}

