/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.label;

import com.atlassian.jira.bc.issue.label.LabelService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DefaultLabelService
implements LabelService {
    private final PermissionManager permissionManager;
    private final IssueManager issueManager;
    private final LabelManager labelManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final CustomFieldManager customFieldManager;
    private final FieldLayoutManager fieldLayoutManager;

    public DefaultLabelService(PermissionManager permissionManager, IssueManager issueManager, LabelManager labelManager, I18nHelper.BeanFactory beanFactory, CustomFieldManager customFieldManager, FieldLayoutManager fieldLayoutManager) {
        this.permissionManager = permissionManager;
        this.issueManager = issueManager;
        this.labelManager = labelManager;
        this.beanFactory = beanFactory;
        this.customFieldManager = customFieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    public LabelService.LabelsResult getLabels(ApplicationUser user, Long issueId) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        ErrorCollection errorCollection = this.validateBrowseIssuePermission(user, issueId);
        if (errorCollection.hasAnyErrors()) {
            return new LabelService.LabelsResult(Collections.emptySet(), errorCollection);
        }
        return new LabelService.LabelsResult(this.labelManager.getLabels(issueId), (ErrorCollection)new SimpleErrorCollection());
    }

    public LabelService.LabelsResult getLabels(ApplicationUser user, Long issueId, Long customFieldId) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        ErrorCollection errorCollection = this.validateBrowseIssuePermission(user, issueId);
        CustomField field = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (field == null) {
            I18nHelper i18n = this.beanFactory.getInstance(user);
            errorCollection.addErrorMessage(i18n.getText("label.service.error.custom.field.doesnt.exist", (Object)customFieldId));
        }
        if (errorCollection.hasAnyErrors()) {
            return new LabelService.LabelsResult(Collections.emptySet(), errorCollection);
        }
        return new LabelService.LabelsResult(this.labelManager.getLabels(issueId, customFieldId), (ErrorCollection)new SimpleErrorCollection());
    }

    public LabelService.SetLabelValidationResult validateSetLabels(ApplicationUser user, Long issueId, Set<String> labels) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        Assertions.notNull((String)"labels", labels);
        ErrorCollection errors = this.validateUpdateIssuePermission(user, issueId, null, labels);
        return new LabelService.SetLabelValidationResult(issueId, null, errors, labels);
    }

    public LabelService.SetLabelValidationResult validateSetLabels(ApplicationUser user, Long issueId, Long customFieldId, Set<String> labels) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        Assertions.notNull((String)"labels", labels);
        ErrorCollection errors = this.validateUpdateIssuePermission(user, issueId, customFieldId, labels);
        CustomField field = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (field == null) {
            I18nHelper i18n = this.beanFactory.getInstance(user);
            errors.addErrorMessage(i18n.getText("label.service.error.custom.field.doesnt.exist", (Object)customFieldId));
        }
        return new LabelService.SetLabelValidationResult(issueId, customFieldId, errors, labels);
    }

    public LabelService.LabelsResult setLabels(ApplicationUser user, LabelService.SetLabelValidationResult result, boolean sendNotification, boolean causeChangeNotification) {
        Assertions.notNull((String)"result", (Object)result);
        if (!result.isValid()) {
            throw new IllegalArgumentException("Cannot set labels with invalid validation result!");
        }
        Set<String> cleanLabels = this.getCleanLabels(result.getLabels());
        Set newLabels = result.getCustomFieldId() != null ? this.labelManager.setLabels(user, result.getIssueId(), result.getCustomFieldId(), cleanLabels, sendNotification, causeChangeNotification) : this.labelManager.setLabels(user, result.getIssueId(), cleanLabels, sendNotification, causeChangeNotification);
        return new LabelService.LabelsResult(newLabels, (ErrorCollection)new SimpleErrorCollection());
    }

    private Set<String> getCleanLabels(Set<String> labels) {
        LinkedHashSet<String> cleanLabels = new LinkedHashSet<String>();
        for (String label : labels) {
            cleanLabels.add(label.trim());
        }
        return cleanLabels;
    }

    public LabelService.AddLabelValidationResult validateAddLabel(ApplicationUser user, Long issueId, String label) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        Assertions.notNull((String)"label", (Object)label);
        ErrorCollection errors = this.validateUpdateIssuePermission(user, issueId, null, CollectionBuilder.newBuilder((Object[])new String[]{label}).asSet());
        return new LabelService.AddLabelValidationResult(issueId, null, errors, label);
    }

    public LabelService.AddLabelValidationResult validateAddLabel(ApplicationUser user, Long issueId, Long customFieldId, String label) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        Assertions.notNull((String)"label", (Object)label);
        ErrorCollection errors = this.validateUpdateIssuePermission(user, issueId, customFieldId, CollectionBuilder.newBuilder((Object[])new String[]{label}).asSet());
        CustomField field = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (field == null) {
            I18nHelper i18n = this.beanFactory.getInstance(user);
            errors.addErrorMessage(i18n.getText("label.service.error.custom.field.doesnt.exist", (Object)customFieldId));
        }
        return new LabelService.AddLabelValidationResult(issueId, customFieldId, errors, label);
    }

    public LabelService.LabelsResult addLabel(ApplicationUser user, LabelService.AddLabelValidationResult result, boolean sendNotification) {
        Assertions.notNull((String)"result", (Object)result);
        if (!result.isValid()) {
            throw new IllegalStateException("Cannot add label with invalid validation result!");
        }
        if (result.getCustomFieldId() != null) {
            this.labelManager.addLabel(user, result.getIssueId(), result.getCustomFieldId(), result.getLabel().trim(), sendNotification);
            return this.getLabels(user, result.getIssueId(), result.getCustomFieldId());
        }
        this.labelManager.addLabel(user, result.getIssueId(), result.getLabel(), sendNotification);
        return this.getLabels(user, result.getIssueId());
    }

    public LabelService.LabelSuggestionResult getSuggestedLabels(ApplicationUser user, Long issueId, String token) {
        ErrorCollection errors = this.validateForSuggestion(user, token);
        if (errors.hasAnyErrors()) {
            return new LabelService.LabelSuggestionResult(Collections.emptySet(), errors);
        }
        return new LabelService.LabelSuggestionResult(this.labelManager.getSuggestedLabels(user, issueId, token), (ErrorCollection)new SimpleErrorCollection());
    }

    public LabelService.LabelSuggestionResult getSuggestedLabels(ApplicationUser user, Long issueId, Long customFieldId, String token) {
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        ErrorCollection errors = this.validateForSuggestion(user, token);
        CustomField field = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (field == null) {
            I18nHelper i18n = this.beanFactory.getInstance(user);
            errors.addErrorMessage(i18n.getText("label.service.error.custom.field.doesnt.exist", (Object)customFieldId));
        }
        if (errors.hasAnyErrors()) {
            return new LabelService.LabelSuggestionResult(Collections.emptySet(), errors);
        }
        return new LabelService.LabelSuggestionResult(this.labelManager.getSuggestedLabels(user, issueId, customFieldId, token), (ErrorCollection)new SimpleErrorCollection());
    }

    private ErrorCollection validateForSuggestion(ApplicationUser user, String token) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (StringUtils.isNotEmpty((String)token) && !LabelParser.isValidLabelName((String)token)) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("label.service.error.label.invalid", token));
        }
        return errors;
    }

    private ErrorCollection validateBrowseIssuePermission(ApplicationUser user, Long issueId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("label.service.error.issue.doesnt.exist", (Object)issueId));
            return errors;
        }
        if (!this.permissionManager.hasPermission(10, (Issue)issue, user)) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("label.service.error.issue.no.permission", issue.getKey()));
        }
        return errors;
    }

    private ErrorCollection validateUpdateIssuePermission(ApplicationUser user, Long issueId, Long customFieldId, Set<String> labels) {
        FieldLayout fieldLayout;
        FieldLayoutItem fieldLayoutItem;
        String fieldId;
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18n = this.beanFactory.getInstance(user);
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        String string = fieldId = customFieldId == null ? "labels" : "customfield_" + customFieldId;
        if (issue == null) {
            errors.addErrorMessage(i18n.getText("label.service.error.issue.doesnt.exist", (Object)issueId));
            return errors;
        }
        if (!this.issueManager.isEditable((Issue)issue, user)) {
            errors.addErrorMessage(i18n.getText("label.service.error.issue.no.edit.permission", issue.getKey()));
        }
        for (String theLabel : labels) {
            String label = theLabel.trim();
            if (!LabelParser.isValidLabelName((String)label)) {
                errors.addError(fieldId, i18n.getText("label.service.error.label.invalid", label));
            }
            if (label.length() > 255) {
                errors.addError(fieldId, i18n.getText("label.service.error.label.toolong", label));
            }
            if (!StringUtils.isBlank((String)label)) continue;
            errors.addError(fieldId, i18n.getText("label.service.error.label.blank"));
        }
        if (!errors.hasAnyErrors() && (fieldLayoutItem = (fieldLayout = this.fieldLayoutManager.getFieldLayout((Issue)issue)).getFieldLayoutItem(fieldId)) != null && fieldLayoutItem.isRequired() && labels.isEmpty()) {
            errors.addError(fieldId, i18n.getText("issue.field.required", i18n.getText(fieldLayoutItem.getOrderableField().getNameKey())));
        }
        return errors;
    }
}

