/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.link;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.link.IssueLinkTypeService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeDestroyer;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class DefaultIssueLinkTypeService
implements IssueLinkTypeService {
    private final PermissionManager permissionManager;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkTypeDestroyer issueLinkTypeDestroyer;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ApplicationProperties applicationProperties;

    public DefaultIssueLinkTypeService(PermissionManager permissionManager, IssueLinkTypeManager issueLinkTypeManager, IssueLinkTypeDestroyer issueLinkTypeDestroyer, I18nHelper.BeanFactory i18nFactory, ApplicationProperties applicationProperties) {
        this.permissionManager = permissionManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueLinkTypeDestroyer = issueLinkTypeDestroyer;
        this.i18nFactory = i18nFactory;
        this.applicationProperties = applicationProperties;
    }

    public ServiceOutcome<IssueLinkType> createIssueLinkType(ApplicationUser user, String name, String outward, String inward) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        if (!this.applicationProperties.getOption("jira.option.issuelinking")) {
            return ServiceOutcomeImpl.error(i18n.getText("admin.issuelinking.status", i18n.getText("admin.common.words.disabled")), ErrorCollection.Reason.NOT_FOUND);
        }
        if (!this.permissionManager.hasPermission(0, user)) {
            return ServiceOutcomeImpl.error(i18n.getText("admin.errors.linking.error.create.no.permission"), ErrorCollection.Reason.FORBIDDEN);
        }
        if (!this.issueLinkTypeManager.getIssueLinkTypesByName(name).isEmpty()) {
            return ServiceOutcomeImpl.error(i18n.getText("admin.errors.linking.error.create.duplicate"));
        }
        this.issueLinkTypeManager.createIssueLinkType(name, outward, inward, null);
        Collection issueLinkTypesByName = this.issueLinkTypeManager.getIssueLinkTypesByName(name);
        if (issueLinkTypesByName.size() != 1) {
            return ServiceOutcomeImpl.error(i18n.getText("admin.errors.linking.error.create.failed.mysteriously"), ErrorCollection.Reason.SERVER_ERROR);
        }
        return ServiceOutcomeImpl.ok(issueLinkTypesByName.iterator().next());
    }

    public ServiceOutcome<IssueLinkType> deleteIssueLinkType(ApplicationUser user, IssueLinkType linkType) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        if (!this.applicationProperties.getOption("jira.option.issuelinking")) {
            return ServiceOutcomeImpl.error(i18n.getText("admin.issuelinking.status", i18n.getText("admin.common.words.disabled")), ErrorCollection.Reason.NOT_FOUND);
        }
        if (!this.permissionManager.hasPermission(0, user)) {
            return ServiceOutcomeImpl.error(i18n.getText("admin.errors.linking.error.delete.no.permission"), ErrorCollection.Reason.FORBIDDEN);
        }
        try {
            this.issueLinkTypeDestroyer.removeIssueLinkType(linkType.getId(), null, user);
            return ServiceOutcomeImpl.ok(linkType);
        }
        catch (RuntimeException e) {
            return ServiceOutcomeImpl.error(e.getMessage(), ErrorCollection.Reason.SERVER_ERROR);
        }
    }

    public ServiceOutcome<Collection<IssueLinkType>> getIssueLinkTypes(ApplicationUser user) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        if (!this.applicationProperties.getOption("jira.option.issuelinking")) {
            return ServiceOutcomeImpl.error(i18n.getText("admin.issuelinking.status", i18n.getText("admin.common.words.disabled")), ErrorCollection.Reason.NOT_FOUND);
        }
        return ServiceOutcomeImpl.ok(Collections.unmodifiableCollection(this.issueLinkTypeManager.getIssueLinkTypes()));
    }

    public ServiceOutcome<IssueLinkType> updateIssueLinkType(ApplicationUser user, IssueLinkType linkType, String name, String outward, String inward) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        if (!this.applicationProperties.getOption("jira.option.issuelinking")) {
            return ServiceOutcomeImpl.error(i18n.getText("admin.issuelinking.status", i18n.getText("admin.common.words.disabled")), ErrorCollection.Reason.NOT_FOUND);
        }
        if (!this.permissionManager.hasPermission(0, user)) {
            return ServiceOutcomeImpl.error(i18n.getText("admin.errors.linking.error.update.no.permission"), ErrorCollection.Reason.FORBIDDEN);
        }
        if (!Objects.equal((Object)name, (Object)linkType.getName()) && !this.issueLinkTypeManager.getIssueLinkTypesByName(name).isEmpty()) {
            return ServiceOutcomeImpl.error(i18n.getText("admin.errors.linking.error.create.duplicate"));
        }
        this.issueLinkTypeManager.updateIssueLinkType(linkType, StringUtils.isEmpty((CharSequence)name) ? linkType.getName() : name, StringUtils.isEmpty((CharSequence)outward) ? linkType.getOutward() : outward, StringUtils.isEmpty((CharSequence)inward) ? linkType.getInward() : inward);
        return ServiceOutcomeImpl.ok(linkType);
    }
}

