/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bulkedit.operation.BulkOperationException;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.Collection;
import java.util.List;

public class BulkUnwatchOperation
implements ProgressAwareBulkOperation {
    public static final String NAME = "BulkUnwatch";
    private final WatcherService watcherService;
    public static final String NAME_KEY = "bulk.unwatch.operation.name";

    public BulkUnwatchOperation(WatcherService watcherService) {
        this.watcherService = watcherService;
    }

    public boolean canPerform(BulkEditBean bulkEditBean, ApplicationUser applicationUser) {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        return this.watcherService.canUnwatchAll((Iterable)selectedIssues, applicationUser);
    }

    public void perform(BulkEditBean bulkEditBean, ApplicationUser remoteUser, Context taskContext) throws BulkOperationException {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        this.watcherService.removeWatcherFromAll((Collection)selectedIssues, remoteUser, remoteUser, taskContext);
    }

    public int getNumberOfTasks(BulkEditBean bulkEditBean) {
        return bulkEditBean.getSelectedIssues().size();
    }

    public String getOperationName() {
        return NAME;
    }

    public String getCannotPerformMessageKey() {
        return "bulk.unwatch.cannotperform";
    }

    public String getNameKey() {
        return NAME_KEY;
    }

    public String getDescriptionKey() {
        return "bulk.unwatch.operation.description";
    }
}

