/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.soy;

import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.output.NullWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoyCacheWarmer {
    private static final Logger log = LoggerFactory.getLogger(SoyCacheWarmer.class);
    private final ExecutorService executorService = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)"Soy Warmer Thread", (ThreadFactories.Type)ThreadFactories.Type.USER));
    private final SoyTemplateRenderer soyTemplateRenderer;

    public SoyCacheWarmer(SoyTemplateRenderer soyTemplateRenderer) {
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public void requestWarm(Set<String> moduleKeys) {
        this.executorService.execute(() -> this.warm((ImmutableSet<String>)ImmutableSet.copyOf((Collection)moduleKeys)));
    }

    private void warm(ImmutableSet<String> modulesToWarm) {
        long warmStartTime = System.currentTimeMillis();
        log.info("Warming {} modules", (Object)modulesToWarm.size());
        for (String completeModuleKey : modulesToWarm) {
            long startTime = System.currentTimeMillis();
            try {
                this.soyTemplateRenderer.render((Appendable)new NullWriter(), completeModuleKey, "", Collections.emptyMap());
            }
            catch (Exception e) {
                log.debug("Caught exception while compiling {} : {}", (Object)completeModuleKey, (Object)e.getMessage());
            }
            long compileTime = System.currentTimeMillis() - startTime;
            log.debug("Compiled {} in {} ms", (Object)completeModuleKey, (Object)compileTime);
        }
        long warmCompleteTime = System.currentTimeMillis() - warmStartTime;
        log.info("Warming {} modules completed in {} ms", (Object)modulesToWarm.size(), (Object)warmCompleteTime);
    }
}

