/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.jfreechart;

import com.atlassian.jira.charts.jfreechart.ChartGenerator;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.util.ChartDefaults;
import com.atlassian.jira.charts.jfreechart.util.ChartUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatedVsResolvedChartGenerator
implements ChartGenerator {
    private static final Logger log = LoggerFactory.getLogger(CreatedVsResolvedChartGenerator.class);
    private final XYDataset createdVsResolved;
    private final TimeSeries trendSeries;
    private final List domainMarkers;
    private I18nBean i18nBean;

    public CreatedVsResolvedChartGenerator(XYDataset createdVsResolved, TimeSeries trendSeries, List domainMarkers, I18nBean i18nBean) {
        this.createdVsResolved = createdVsResolved;
        this.trendSeries = trendSeries;
        this.domainMarkers = domainMarkers;
        this.i18nBean = i18nBean;
    }

    public ChartHelper generateChart() {
        boolean legend = false;
        boolean tooltips = true;
        boolean urls = true;
        JFreeChart chart = ChartFactory.createTimeSeriesChart(null, null, null, (XYDataset)this.createdVsResolved, (boolean)legend, (boolean)tooltips, (boolean)urls);
        CreatedVsResolvedChartGenerator.setTimeSeriesChartDefaults(chart, (Plot)chart.getXYPlot(), this.i18nBean);
        chart.setBorderVisible(false);
        XYPlot plot = chart.getXYPlot();
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        TickUnitSource units = NumberAxis.createIntegerTickUnits();
        yAxis.setStandardTickUnits(units);
        XYDifferenceRenderer xyDifferenceRenderer = new XYDifferenceRenderer((Paint)ChartDefaults.RED_DIFF, (Paint)ChartDefaults.GREEN_DIFF, true);
        xyDifferenceRenderer.setSeriesPaint(0, (Paint)ChartDefaults.RED);
        xyDifferenceRenderer.setSeriesPaint(1, (Paint)ChartDefaults.BRIGHT_GREEN);
        xyDifferenceRenderer.setShape((Shape)new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        xyDifferenceRenderer.setBaseStroke(ChartDefaults.defaultStroke);
        xyDifferenceRenderer.setStroke(ChartDefaults.defaultStroke);
        plot.setRenderer((XYItemRenderer)xyDifferenceRenderer);
        XYPlot subPlot = null;
        if (this.trendSeries != null) {
            XYLineAndShapeRenderer xyLineAndShapeRenderer = new XYLineAndShapeRenderer(true, true);
            xyLineAndShapeRenderer.setShape(xyDifferenceRenderer.getSeriesShape(0));
            TimeSeriesCollection subDataset = new TimeSeriesCollection();
            subDataset.addSeries(this.trendSeries);
            ValueAxis domainAxis = plot.getDomainAxis();
            ValueAxis rangeAxis = null;
            try {
                rangeAxis = (ValueAxis)plot.getRangeAxis().clone();
            }
            catch (CloneNotSupportedException ex) {
                log.error("Failed to clone Y axis", (Throwable)ex);
            }
            subPlot = new XYPlot((XYDataset)subDataset, domainAxis, rangeAxis, (XYItemRenderer)xyLineAndShapeRenderer);
            CombinedDomainXYPlot combinedPlot = new CombinedDomainXYPlot(plot.getDomainAxis());
            combinedPlot.setRenderer(plot.getRenderer());
            combinedPlot.setGap(10.0);
            combinedPlot.add(plot, 3);
            combinedPlot.add(subPlot);
            subPlot.setOutlineStroke(null);
            chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)combinedPlot, false);
            CreatedVsResolvedChartGenerator.setTimeSeriesChartDefaults(chart, (Plot)subPlot, this.i18nBean);
        }
        if (this.domainMarkers != null && !this.domainMarkers.isEmpty()) {
            for (Object domainMarker : this.domainMarkers) {
                ValueMarker valueMarker = (ValueMarker)domainMarker;
                valueMarker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
                valueMarker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
                plot.addDomainMarker((Marker)valueMarker);
                if (subPlot == null) continue;
                subPlot.addDomainMarker((Marker)valueMarker);
            }
        }
        return new ChartHelper(chart);
    }

    private static void setTimeSeriesChartDefaults(JFreeChart chart, Plot genericPlot, I18nBean i18nBean) {
        ChartUtil.setDefaults((JFreeChart)chart, (I18nHelper)i18nBean);
        XYPlot plot = (XYPlot)genericPlot;
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseItemLabelFont(ChartDefaults.defaultFont);
        renderer.setBaseItemLabelPaint((Paint)ChartDefaults.axisLabelColor);
        for (int j = 0; j < ChartDefaults.darkColors.length; ++j) {
            renderer.setSeriesPaint(j, (Paint)ChartDefaults.darkColors[j]);
            renderer.setSeriesStroke(j, ChartDefaults.defaultStroke);
        }
        renderer.setBaseShapesVisible(false);
        renderer.setBaseStroke(ChartDefaults.defaultStroke);
    }
}

