/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.beehive.db.spi.ClusterLockDao;
import com.atlassian.beehive.db.spi.ClusterLockStatus;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.exception.DataAccessException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JiraClusterLockDao
implements ClusterLockDao {
    private final EntityEngine entityEngine;

    public JiraClusterLockDao(EntityEngine entityEngine) {
        this.entityEngine = entityEngine;
    }

    @Nullable
    public ClusterLockStatus getClusterLockStatusByName(@Nonnull String lockName) {
        return (ClusterLockStatus)this.entityEngine.selectFrom(Entity.CLUSTER_LOCK_STATUS).whereEqual("lockName", lockName).singleValue();
    }

    public boolean tryUpdateAcquireLock(@Nonnull String lockName, @Nonnull String nodeId, long updateTime) {
        int rows = Update.into(Entity.CLUSTER_LOCK_STATUS).set("lockedByNode", nodeId).set("updateTime", updateTime).whereEqual("lockName", lockName).andEqual("lockedByNode", (String)null).execute(this.entityEngine);
        if (rows == 0) {
            return false;
        }
        if (rows == 1) {
            return true;
        }
        throw new IllegalStateException("Too many rows updated in JiraClusterLockDao: " + rows + " for lock name: " + lockName);
    }

    public void insertEmptyClusterLock(@Nonnull String lockName, long updateTime) {
        block2: {
            try {
                this.entityEngine.createValue(Entity.CLUSTER_LOCK_STATUS, new ClusterLockStatus(lockName, null, updateTime));
            }
            catch (DataAccessException ex) {
                if (this.getClusterLockStatusByName(lockName) != null) break block2;
                throw ex;
            }
        }
    }

    public void unlock(@Nonnull String lockName, @Nonnull String nodeId, long updateTime) {
        int rowsUpdated = Update.into(Entity.CLUSTER_LOCK_STATUS).set("lockedByNode", (String)null).set("updateTime", updateTime).whereEqual("lockName", lockName).andEqual("lockedByNode", nodeId).execute(this.entityEngine);
        if (rowsUpdated == 0) {
            throw new IllegalMonitorStateException("Attempt to unlock '" + lockName + "' but it was not held by this node ('" + nodeId + "').");
        }
    }

    public void deleteLocksHeldByNode(String nodeId) {
        this.entityEngine.delete(Delete.from(Entity.CLUSTER_LOCK_STATUS).whereEqual("lockedByNode", nodeId));
    }
}

