/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import java.util.Optional;

public class ComponentAccessorWorker
implements ComponentAccessor.Worker {
    public <T> Optional<T> getComponentSafely(Class<T> componentClass) {
        if (ComponentManager.getInstance().getState().isContainerInitialised()) {
            return Optional.ofNullable(this.getComponent(componentClass));
        }
        return Optional.empty();
    }

    public <T> T getComponent(Class<T> componentClass) {
        return ComponentManager.getComponent(componentClass);
    }

    public <T> T getComponentOfType(Class<T> componentClass) {
        return ComponentManager.getComponentInstanceOfType(componentClass);
    }

    public <T> T getOSGiComponentInstanceOfType(Class<T> componentClass) {
        return ComponentManager.getOSGiComponentInstanceOfType(componentClass);
    }
}

