/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.component.debug;

import com.atlassian.event.api.EventListenerRegistrar;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Injector;
import org.picocontainer.monitors.AbstractComponentMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListenerDetectorMonitor
extends AbstractComponentMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(EventListenerDetectorMonitor.class);
    public static Predicate<Class<?>> containsEventRegistrarInAnyOfConstructors = new Predicate<Class<?>>(){

        public boolean apply(@Nullable Class<?> input) {
            List<Constructor<?>> constructors = Arrays.asList(input.getConstructors());
            return Iterables.any(constructors, containsEventRegistrarInParams);
        }
    };
    public static final Predicate<Constructor<?>> containsEventRegistrarInParams = new Predicate<Constructor<?>>(){

        public boolean apply(@Nullable Constructor<?> input) {
            ArrayList params = Lists.newArrayList((Object[])input.getParameterTypes());
            Predicate predicate = Predicates.assignableFrom(EventListenerRegistrar.class);
            return Iterables.any((Iterable)params, (Predicate)predicate);
        }
    };

    public EventListenerDetectorMonitor(ComponentMonitor delegate) {
        super(delegate);
    }

    public EventListenerDetectorMonitor() {
    }

    public Injector newInjector(Injector injector) {
        Class componentImplementation = injector.getComponentImplementation();
        if (containsEventRegistrarInAnyOfConstructors.apply((Object)componentImplementation)) {
            LOG.warn("Class {} contains event registrar in constructor", (Object)componentImplementation.getCanonicalName());
        }
        return injector;
    }
}

