/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.cache.request.RequestCacheFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureDisabledEvent;
import com.atlassian.jira.config.FeatureEnabledEvent;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.FeatureStore;
import com.atlassian.jira.config.feature.FeaturesLoader;
import com.atlassian.jira.config.feature.FeaturesMapHolder;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.tenancy.api.TenantAccessor;
import com.atlassian.tenancy.api.event.TenantArrivedEvent;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultFeatureManager
implements FeatureManager,
Startable,
InitializingComponent {
    private final JiraAuthenticationContext authenticationContext;
    private final FeatureStore featureStore;
    private final JiraProperties jiraSystemProperties;
    private final TenantAccessor tenantAccessor;
    private final FeaturesMapHolder features;
    private final CachedReference<Set<String>> siteFeatures;
    private final Cache<String, Set<String>> userFeaturesCache;
    private final RequestCache<Boolean, DarkFeatures> darkFeatures;
    private final ComponentReference<EventPublisher> eventPublisherRef = ComponentAccessor.getComponentReference(EventPublisher.class);
    private final ComponentReference<GlobalPermissionManager> permissionManagerRef = ComponentAccessor.getComponentReference(GlobalPermissionManager.class);

    public DefaultFeatureManager(JiraAuthenticationContext authenticationContext, FeatureStore featureStore, JiraProperties jiraSystemProperties, CacheManager cacheManager, TenantAccessor tenantAccessor, FeaturesLoader featuresLoader, RequestCacheFactory cacheFactory) {
        this.jiraSystemProperties = jiraSystemProperties;
        this.authenticationContext = authenticationContext;
        this.featureStore = featureStore;
        this.userFeaturesCache = this.initUserFeatureCache(cacheManager);
        this.siteFeatures = this.initSiteFeatureCache(cacheManager);
        this.tenantAccessor = tenantAccessor;
        this.features = new FeaturesMapHolder(featuresLoader);
        this.darkFeatures = cacheFactory.createRequestCache(DefaultFeatureManager.class.getName() + ".darkFeatures", this::getDarkFeatures);
    }

    @Override
    public void afterInstantiation() throws Exception {
        EventPublisher eventPublisher = (EventPublisher)this.eventPublisherRef.get();
        eventPublisher.register((Object)this);
        eventPublisher.register((Object)this.features);
    }

    private Cache<String, Set<String>> initUserFeatureCache(CacheManager cacheManager) {
        return cacheManager.getCache(DefaultFeatureManager.class.getName() + ".userFeaturesCache", (CacheLoader)new UserFeatureCacheLoader());
    }

    private CachedReference<Set<String>> initSiteFeatureCache(CacheManager cacheManager) {
        return cacheManager.getCachedReference(DefaultFeatureManager.class, "siteFeatures", (Supplier)new SiteFeaturesSupplier());
    }

    private boolean isEnabled(String featureKey, boolean isUserSettable) {
        return this.features.enabledFeatures().contains(featureKey) || ((DarkFeatures)this.darkFeatures.get((Object)isUserSettable)).isFeatureEnabled(featureKey);
    }

    public boolean isEnabled(String featureKey) {
        return this.isEnabled(featureKey, true);
    }

    public boolean isEnabled(Feature feature) {
        if (feature instanceof CoreFeatures) {
            return this.isEnabled((CoreFeatures)feature);
        }
        return this.isEnabled(feature.featureKey(), true);
    }

    public boolean isEnabledForUser(@Nullable ApplicationUser user, String featureKey) {
        return this.getDarkFeaturesForUser(user).isFeatureEnabled(featureKey);
    }

    public boolean isEnabled(CoreFeatures feature) {
        return this.isEnabled(feature.featureKey(), feature.isDevFeature());
    }

    public boolean isOnDemand() {
        return this.isEnabled(CoreFeatures.ON_DEMAND);
    }

    public Set<String> getEnabledFeatureKeys() {
        return this.features.enabledFeatures();
    }

    public DarkFeatures getDarkFeatures() {
        return (DarkFeatures)this.darkFeatures.get((Object)true);
    }

    private DarkFeatures getDarkFeatures(boolean includeUserSettable) {
        if (includeUserSettable) {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            return new DarkFeatures(this.getEnabledFeatureKeys(), this.getSiteEnabledFeatures(), this.getUserEnabledFeatures(user));
        }
        return this.jiraSystemProperties.isDarkFeaturesDisabled() ? new DarkFeatures(Collections.emptySet(), Collections.emptySet(), Collections.emptySet()) : new DarkFeatures(this.getEnabledFeatureKeys(), this.getSiteEnabledFeatures(), Collections.emptySet());
    }

    public DarkFeatures getDarkFeaturesForUser(@Nullable ApplicationUser user) {
        if (this.jiraSystemProperties.isDarkFeaturesDisabled()) {
            return new DarkFeatures(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        return new DarkFeatures(this.getEnabledFeatureKeys(), this.getSiteEnabledFeatures(), this.getUserEnabledFeatures(user));
    }

    public void enableUserDarkFeature(ApplicationUser user, String feature) {
        this.changeUserDarkFeature(user, feature, true);
    }

    public void disableUserDarkFeature(ApplicationUser user, String feature) {
        this.changeUserDarkFeature(user, feature, false);
    }

    public void enableSiteDarkFeature(String feature) {
        this.changeSiteDarkFeature(feature, true);
    }

    public void disableSiteDarkFeature(String feature) {
        this.changeSiteDarkFeature(feature, false);
    }

    public boolean hasSiteEditPermission() {
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        return ((GlobalPermissionManager)this.permissionManagerRef.get()).hasPermission(GlobalPermissionKey.ADMINISTER, loggedInUser);
    }

    private void changeUserDarkFeature(ApplicationUser user, String feature, boolean enable) {
        CoreFeatures coreFeature = CoreFeatures.forFeatureKey((String)feature);
        if (coreFeature != null && !coreFeature.isDevFeature()) {
            throw new IllegalStateException("User cannot set feature '" + feature + "' at runtime. It must be set by an admin via properties.");
        }
        HashSet enabledFeatures = Sets.newHashSet(this.getUserEnabledFeatures(user));
        if (enable == enabledFeatures.contains(feature)) {
            return;
        }
        if (enable) {
            this.featureStore.create(feature, user.getKey());
            enabledFeatures.add(feature);
        } else {
            this.featureStore.delete(feature, user.getKey());
            enabledFeatures.remove(feature);
        }
        this.userFeaturesCache.remove((Object)user.getKey());
        this.darkFeatures.removeAll();
        ((EventPublisher)this.eventPublisherRef.get()).publish(enable ? new FeatureEnabledEvent(feature, user) : new FeatureDisabledEvent(feature, user));
    }

    private void changeSiteDarkFeature(String feature, boolean enable) {
        if (!this.hasSiteEditPermission()) {
            throw new IllegalStateException("User " + this.authenticationContext.getLoggedInUser() + " does not have permission to change site dark features");
        }
        Set<String> enabledFeatures = this.getSiteEnabledFeatures();
        if (enable == enabledFeatures.contains(feature)) {
            return;
        }
        if (enable) {
            this.featureStore.create(feature, null);
            enabledFeatures.add(feature);
        } else {
            this.featureStore.delete(feature, null);
            enabledFeatures.remove(feature);
        }
        this.siteFeatures.reset();
        this.darkFeatures.removeAll();
        ((EventPublisher)this.eventPublisherRef.get()).publish(enable ? new FeatureEnabledEvent(feature) : new FeatureDisabledEvent(feature));
    }

    private Set<String> getUserEnabledFeatures(ApplicationUser user) {
        if (user != null) {
            return (Set)this.userFeaturesCache.get((Object)user.getKey());
        }
        return Sets.newHashSet();
    }

    private Set<String> getUserEnabledFeaturesFromStore(String userKey) {
        return this.featureStore.getUserFeatures(userKey);
    }

    private Set<String> getSiteEnabledFeatures() {
        return (Set)this.siteFeatures.get();
    }

    private Set<String> getSiteEnabledFeaturesFromStore() {
        return this.featureStore.getSiteFeatures();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.invalidateCaches();
    }

    @EventListener
    public void onTenantArrived(TenantArrivedEvent event) {
        this.invalidateCaches();
    }

    private void invalidateCaches() {
        this.userFeaturesCache.removeAll();
        this.darkFeatures.removeAll();
        this.siteFeatures.reset();
        this.features.clearCache();
    }

    public void start() throws Exception {
        this.features.start();
    }

    private boolean isTenanted() {
        return !Iterables.isEmpty((Iterable)this.tenantAccessor.getAvailableTenants());
    }

    private class SiteFeaturesSupplier
    implements Supplier<Set<String>> {
        private SiteFeaturesSupplier() {
        }

        public Set<String> get() {
            if (DefaultFeatureManager.this.isTenanted()) {
                return DefaultFeatureManager.this.getSiteEnabledFeaturesFromStore();
            }
            return ImmutableSet.of();
        }
    }

    private class UserFeatureCacheLoader
    implements CacheLoader<String, Set<String>> {
        private UserFeatureCacheLoader() {
        }

        @Nonnull
        public Set<String> load(@Nonnull String key) {
            if (DefaultFeatureManager.this.isTenanted()) {
                return DefaultFeatureManager.this.getUserEnabledFeaturesFromStore(key);
            }
            return ImmutableSet.of();
        }
    }
}

