/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.ApplicationPropertiesStore;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.property.BooleanApplicationPropertySetEvent;
import com.atlassian.jira.event.property.StringApplicationPropertySetEvent;
import com.atlassian.jira.util.LocaleParser;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class ApplicationPropertiesImpl
implements ApplicationProperties {
    private static final Logger log = LoggerFactory.getLogger(ApplicationPropertiesImpl.class);
    @VisibleForTesting
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final ApplicationPropertiesStore applicationPropertiesStore;
    private final Locale defaultLocale = Locale.getDefault();

    public ApplicationPropertiesImpl(ApplicationPropertiesStore applicationPropertiesStore) {
        this.applicationPropertiesStore = applicationPropertiesStore;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    public String getText(String name) {
        return this.applicationPropertiesStore.getTextFromDb(name);
    }

    public String getString(String name) {
        return this.applicationPropertiesStore.getStringFromDb(name);
    }

    public Collection<String> getDefaultKeys() {
        return this.getDefaultProperties().keySet();
    }

    public String getDefaultBackedString(String name) {
        return this.applicationPropertiesStore.getString(name);
    }

    public String getDefaultBackedText(String name) {
        String value = null;
        try {
            value = this.getText(name);
        }
        catch (Exception e) {
            log.warn("Exception getting property '" + name + "' from database. Using default");
        }
        if (value == null) {
            value = this.getDefaultString(name);
        }
        return value;
    }

    public String getDefaultString(String name) {
        return this.getDefaultProperties().get(name);
    }

    public boolean getOption(String key) {
        return this.applicationPropertiesStore.getOption(key);
    }

    public Collection<String> getKeys() {
        return this.applicationPropertiesStore.getKeysStoredInDb();
    }

    public Map<String, Object> asMap() {
        return this.applicationPropertiesStore.getPropertiesAsMap();
    }

    public void setString(String key, String value) {
        this.applicationPropertiesStore.setString(key, value);
        ((EventPublisher)ComponentAccessor.getComponent(EventPublisher.class)).publish((Object)new StringApplicationPropertySetEvent(key, value));
    }

    public void setText(String key, String value) {
        this.applicationPropertiesStore.setText(key, value);
        ((EventPublisher)ComponentAccessor.getComponent(EventPublisher.class)).publish((Object)new StringApplicationPropertySetEvent(key, value));
    }

    public void setOption(String key, boolean value) {
        this.applicationPropertiesStore.setOption(key, value);
        ((EventPublisher)ComponentAccessor.getComponent(EventPublisher.class)).publish((Object)new BooleanApplicationPropertySetEvent(key, Boolean.valueOf(value)));
        if ("jira.option.allowunassigned".equals(key)) {
            ComponentAccessor.getFieldLayoutManager().refresh();
        }
    }

    public String getEncoding() {
        String encoding = this.getString("webwork.i18n.encoding");
        if (!TextUtils.stringSet((String)encoding)) {
            encoding = DEFAULT_ENCODING;
            this.setString("webwork.i18n.encoding", encoding);
        }
        return encoding;
    }

    public String getMailEncoding() {
        String encoding = this.getDefaultBackedString("jira.i18n.email.encoding");
        if (!TextUtils.stringSet((String)encoding)) {
            encoding = this.getEncoding();
        }
        return encoding;
    }

    public String getContentType() {
        return "text/html; charset=" + this.getEncoding();
    }

    public void refresh() {
        this.applicationPropertiesStore.refreshDbProperties();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("propertiesManager", (Object)this.applicationPropertiesStore).toString();
    }

    private Map<String, String> getDefaultProperties() {
        return this.applicationPropertiesStore.getDefaultsWithOverlays();
    }

    public Locale getDefaultLocale() {
        String localeString = this.getDefaultBackedString("jira.i18n.default.locale");
        if (localeString != null) {
            return LocaleParser.parseLocale((String)localeString);
        }
        return this.defaultLocale;
    }

    public Collection<String> getStringsWithPrefix(String prefix) {
        return this.applicationPropertiesStore.getStringsWithPrefixFromDb(prefix);
    }
}

