/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.util;

import com.atlassian.jira.cluster.ClusterNodePropertiesImpl;
import com.atlassian.jira.config.util.JiraHome;
import java.io.File;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractJiraHome
implements JiraHome {
    @Nonnull
    public File getHome() {
        ClusterNodePropertiesImpl clusterNodeProperties = new ClusterNodePropertiesImpl(this);
        String sharedHomePath = clusterNodeProperties.getSharedHome();
        if (StringUtils.isEmpty((String)sharedHomePath)) {
            return this.getLocalHome();
        }
        return new File(sharedHomePath);
    }

    public final File getLogDirectory() {
        return new File(this.getLocalHome(), "log");
    }

    public final File getCachesDirectory() {
        return new File(this.getLocalHome(), "caches");
    }

    public File getSharedCachesDirectory() {
        return new File(this.getHome(), "caches");
    }

    public final File getExportDirectory() {
        return new File(this.getHome(), "export");
    }

    public final File getImportDirectory() {
        return new File(this.getHome(), "import");
    }

    public final File getImportAttachmentsDirectory() {
        return new File(this.getImportDirectory(), "attachments");
    }

    public final File getPluginsDirectory() {
        return new File(this.getHome(), "plugins");
    }

    public final File getDataDirectory() {
        return new File(this.getHome(), "data");
    }

    public final String getHomePath() {
        return this.getHome().getAbsolutePath();
    }

    public final String getLocalHomePath() {
        return this.getLocalHome().getAbsolutePath();
    }
}

