/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntityKey;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroup;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroupCache;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.map.CacheObject;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

class LazyOfBizGroupCache
implements OfBizGroupCache {
    private final OfBizDelegator ofBizDelegator;
    private final Cache<DirectoryEntityKey, CacheObject<OfBizGroup>> cache;

    public LazyOfBizGroupCache(CacheManager cacheManager, OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
        this.cache = cacheManager.getCache(LazyOfBizGroupCache.class.getName() + ".groupCache", (CacheLoader)new GroupCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).flushable().build());
    }

    @Override
    public boolean isCacheInitialized() {
        return true;
    }

    @Override
    public void refresh() {
        this.cache.removeAll();
    }

    @Override
    public OfBizGroup getCaseInsensitive(long directoryId, String name) {
        CacheObject cacheValue = (CacheObject)this.cache.get((Object)DirectoryEntityKey.getKeyLowerCase(directoryId, name));
        if (cacheValue == null) {
            return null;
        }
        return (OfBizGroup)cacheValue.getValue();
    }

    @Override
    public DirectoryEntityKey refresh(OfBizGroup group) {
        DirectoryEntityKey key = DirectoryEntityKey.getKeyLowerCase(group);
        this.cache.remove((Object)key);
        return key;
    }

    @Override
    public void remove(long directoryId, String name) {
        this.cache.remove((Object)DirectoryEntityKey.getKeyLowerCase(directoryId, name));
    }

    @Override
    public void remove(DirectoryEntityKey key) {
        this.cache.remove((Object)key);
    }

    private class GroupCacheLoader
    implements CacheLoader<DirectoryEntityKey, CacheObject<OfBizGroup>> {
        private GroupCacheLoader() {
        }

        @Nonnull
        public CacheObject<OfBizGroup> load(@Nonnull DirectoryEntityKey key) {
            GenericValue group = (GenericValue)Select.columns(OfBizGroup.SUPPORTED_FIELDS).from("Group").whereEqual("directoryId", key.getDirectoryId()).andEqual("lowerGroupName", key.getName()).runWith(LazyOfBizGroupCache.this.ofBizDelegator).singleValue();
            if (group == null) {
                return CacheObject.NULL();
            }
            return CacheObject.wrap(OfBizGroup.from(group));
        }
    }
}

