/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n;

import com.atlassian.jira.i18n.DefaultMessage;
import com.atlassian.jira.i18n.DefaultMessageCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.message.MessageCollection;
import java.io.Serializable;
import java.util.Locale;

public abstract class AbstractI18nResolver
implements I18nResolver {
    private static final Serializable[] EMPTY_SERIALIZABLE = new Serializable[0];

    public String getText(String key, Serializable ... arguments) {
        Serializable[] resolvedArguments = new Serializable[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Serializable argument = arguments[i];
            resolvedArguments[i] = argument instanceof Message ? this.getText((Message)argument) : arguments[i];
        }
        return this.resolveText(key, resolvedArguments);
    }

    public String getText(Locale locale, String key, Serializable ... arguments) {
        Assertions.notNull((Object)locale);
        Serializable[] resolvedArguments = new Serializable[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Serializable argument = arguments[i];
            resolvedArguments[i] = argument instanceof Message ? this.getText(locale, (Message)argument) : arguments[i];
        }
        return this.resolveText(locale, key, resolvedArguments);
    }

    public String getText(String key) {
        return this.resolveText(key, EMPTY_SERIALIZABLE);
    }

    public String getText(Locale locale, String key) {
        Assertions.notNull((Object)locale);
        return this.resolveText(locale, key, EMPTY_SERIALIZABLE);
    }

    public String getText(Message message) {
        return this.getText(message.getKey(), message.getArguments());
    }

    public String getText(Locale locale, Message message) {
        return this.getText(locale, message.getKey(), message.getArguments());
    }

    public abstract String resolveText(String var1, Serializable[] var2);

    public abstract String resolveText(Locale var1, String var2, Serializable[] var3);

    public Message createMessage(String key, Serializable ... arguments) {
        return new DefaultMessage(key, arguments);
    }

    public MessageCollection createMessageCollection() {
        return new DefaultMessageCollection();
    }
}

